<?php $__env->startSection('content'); ?>
  
  <div class="page-header">
    <h4 class="mb-0">
      <i class="bi bi-cart-plus text-primary"></i>
      إضافة مصروف جديد
    </h4>
    <a href="<?php echo e(route('expenses.index')); ?>" class="btn btn-outline-secondary">
      <i class="bi bi-arrow-right me-1"></i> رجوع
    </a>
  </div>



  <div class="card">
    <div class="card-body">
      <form method="POST" action="<?php echo e(route('expenses.store')); ?>">
        <?php echo csrf_field(); ?>

        
        <div class="form-section">
          <div class="form-section-title">
            <i class="bi bi-info-circle"></i>
            <span>المعلومات الأساسية</span>
          </div>
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label form-label-required">النوع</label>
              <select name="type" class="form-select" required>
                <option value="operational">تشغيلي</option>
                <option value="aid">مساعدات</option>
                <option value="logistics">لوجستي</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">البند الفرعي (التصنيف)</label>
              <input list="categoryOptions" name="category" class="form-control" placeholder="اختر أو اكتب...">
              <datalist id="categoryOptions">
                <option value="المرتبات">
                <option value="الايجارات">
                <option value="فواتير الموبايل والإنترنت">
                <option value="فواتير الكهرباء والمياه">
                <option value="أدوات مكتبية وورق">
                <option value="نثريات">
                <option value="صيانة">
                <option value="وقود ومواصلات">
              </datalist>
            </div>
          </div>
        </div>

        
        <div class="form-section">
          <div class="form-section-title">
            <i class="bi bi-cash-stack"></i>
            <span>البيانات المالية</span>
          </div>
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label form-label-required">المبلغ</label>
              <div class="input-group">
                <input name="amount" type="number" step="0.01" class="form-control" required>
              </div>
            </div>
            <div class="col-md-6">
              <label class="form-label form-label-required">
                <i class="bi bi-safe text-primary me-1"></i>
                الخزينة (مصدر الصرف)
              </label>
              <select name="treasury_id" class="form-select" required>
                <option value="">-- اختر الخزينة --</option>
                <?php if(isset($treasuries) && $treasuries->count() > 0): ?>
                  <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($treasury->id); ?>" <?php echo e(old('treasury_id') == $treasury->id ? 'selected' : ''); ?>>
                      <?php echo e($treasury->name); ?>

                      <?php if($treasury->type_name): ?>
                        (<?php echo e($treasury->type_name); ?>)
                      <?php endif; ?>
                       - الرصيد: <?php echo e(number_format($treasury->current_balance, 2)); ?> <?php echo e($treasury->currency); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                  <option value="" disabled>لا توجد خزائن متاحة</option>
                <?php endif; ?>
              </select>
              <small class="text-muted">سيتم خصم المبلغ من رصيد الخزينة المختارة</small>
            </div>
          </div>
        </div>

        
        <div class="form-section">
          <div class="form-section-title">
            <i class="bi bi-diagram-3"></i>
            <span>التخصيص</span>
          </div>
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">المستفيد</label>
              <select name="beneficiary_id" class="form-select">
                <option value="">— اختر المستفيد —</option>
                <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($b->id); ?>"><?php echo e($b->full_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">المشروع</label>
              <select name="project_id" class="form-select">
                <option value="">— اختر المشروع —</option>
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($p->id); ?>"><?php echo e($p->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">الحملة</label>
              <select name="campaign_id" class="form-select">
                <option value="">— اختر الحملة —</option>
                <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">دار الضيافة</label>
              <select name="guest_house_id" class="form-select">
                <option value="">— اختر دار الضيافة —</option>
                <?php $__currentLoopData = $guestHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($g->id); ?>"><?php echo e($g->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">مساحة العمل (Workspace)</label>
              <select name="workspace_id" class="form-select">
                <option value="">— اختر مساحة العمل —</option>
                <?php $__currentLoopData = $workspaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($w->id); ?>"><?php echo e($w->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
        </div>

        
        <div class="form-section">
          <div class="form-section-title">
            <i class="bi bi-pencil-square"></i>
            <span>ملاحظات</span>
          </div>
          <div class="row g-3">
            <div class="col-12">
              <label class="form-label">وصف المصروف</label>
              <textarea name="description" class="form-control" rows="3"
                placeholder="أضف تفاصيل المصروف هنا..."></textarea>
            </div>
          </div>
        </div>

        
        <div class="d-flex gap-2 justify-content-end">
          <a href="<?php echo e(route('expenses.index')); ?>" class="btn btn-outline-secondary">
            <i class="bi bi-x-lg me-1"></i> إلغاء
          </a>
          <button class="btn btn-primary">
            <i class="bi bi-check-lg me-1"></i> حفظ المصروف
          </button>
        </div>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <style>
        /* Fix Select2 Text Visibility & Dark Mode Support */
        .select2-results__option {
            color: var(--dark) !important;
            font-weight: 500;
            background-color: var(--bg-card) !important;
        }
        .select2-container--bootstrap-5 .select2-dropdown {
            background-color: var(--bg-card) !important;
            border-color: var(--gray-200) !important;
        }
        .select2-container--bootstrap-5 .select2-dropdown .select2-results__options .select2-results__option.select2-results__option--highlighted {
            color: #fff !important;
            background-color: var(--primary) !important;
        }
        .select2-search__field {
            color: var(--dark) !important;
            background-color: var(--gray-100) !important;
            border-color: var(--gray-200) !important;
        }
        /* Enhance Select2 containers */
        .select2-container--bootstrap-5 .select2-selection {
            background-color: var(--bg-card) !important;
            color: var(--dark) !important;
            border-color: var(--gray-200) !important;
            padding-top: 0.35rem; 
            padding-bottom: 0.35rem;
            min-height: 45px;
            display: flex;
            align-items: center;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            color: var(--dark) !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        // Initialize Select2 on all form-select elements
        $('select.form-select').select2({
            theme: 'bootstrap-5',
            dir: 'rtl',
            width: '100%',
            placeholder: 'اختر...',
            allowClear: true,
            language: {
                noResults: function () { return "لا توجد نتائج"; },
                searching: function () { return "جاري البحث..."; }
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/expenses/create.blade.php ENDPATH**/ ?>