<?php $__env->startSection('content'); ?>
  
  <div class="card welcome-card mb-4 border-0"
    style="background: linear-gradient(135deg, #fff7ed 0%, #ffedd5 100%);">
    <div class="d-flex justify-content-between align-items-center p-4">
      <div class="d-flex align-items-center gap-4">
        <div class="bg-warning text-white p-3 rounded-circle shadow-lg d-flex align-items-center justify-content-center"
          style="width: 60px; height: 60px;">
          <i class="bi bi-megaphone fs-3"></i>
        </div>
        <div>
          <h2 class="fw-bold mb-1">إدارة الحملات</h2>
          <p class="text-muted mb-0 lead">تخطيط وإطلاق الحملات الموسمية والتسويقية</p>
        </div>
      </div>
      <div>
        <a href="<?php echo e(route('campaigns.create')); ?>" class="btn btn-primary btn-lg shadow-sm">
          <i class="bi bi-plus-lg me-2"></i> إضافة حملة
        </a>
      </div>
    </div>
  </div>

  
  <div class="card border-0 shadow-sm mb-4">
    <div class="card-header bg-white py-3">
      <h5 class="mb-0 fw-bold"><i class="bi bi-funnel me-2 text-primary"></i> تصفية والبحث</h5>
    </div>
    <div class="card-body">
      <form method="GET">
        <div class="row g-3 align-items-end">
          <div class="col-md-4">
            <label class="form-label fw-bold">بحث بالاسم</label>
            <div class="input-group">
              <span class="input-group-text bg-light border-end-0"><i class="bi bi-search text-muted"></i></span>
              <input name="q" value="<?php echo e($q ?? ''); ?>" class="form-control border-start-0" placeholder="اسم الحملة...">
            </div>
          </div>
          <div class="col-md-3">
            <label class="form-label fw-bold">الحالة</label>
            <select name="status" class="form-select">
              <option value="">الكل</option>
              <option value="active" <?php if(($status ?? '') === 'active'): echo 'selected'; endif; ?>>نشط</option>
              <option value="archived" <?php if(($status ?? '') === 'archived'): echo 'selected'; endif; ?>>مؤرشف</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label fw-bold">السنة</label>
            <input name="season_year" value="<?php echo e($year ?? ''); ?>" class="form-control" type="number" placeholder="2025">
          </div>
          <div class="col-md-2">
            <button class="btn btn-primary w-100 fw-bold">
              تطبيق
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <div class="row g-3">
    <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 position-relative animate-hover">
          <div class="card-body">
            <div class="d-flex align-items-center gap-3 mb-3">
              <div
                class="rounded-circle bg-warning-subtle text-warning d-flex align-items-center justify-content-center flex-shrink-0"
                style="width:56px;height:56px">
                <i class="bi bi-megaphone fs-4"></i>
              </div>
              <div class="overflow-hidden flex-grow-1">
                <h5 class="mb-1 text-truncate fw-bold">
                  <a href="<?php echo e(route('campaigns.show', $c)); ?>" class="text-dark text-decoration-none stretched-link">
                    <?php echo e($c->name); ?>

                  </a>
                </h5>
                <div class="text-muted small">موسم <?php echo e($c->season_year); ?></div>
              </div>
              <div class="ms-auto" style="z-index: 2;">
                  <?php if(isset($c->pendingRequest) && $c->pendingRequest): ?>
                      <span class="badge bg-warning bg-opacity-10 text-warning d-flex align-items-center px-3 py-2 rounded-pill">
                          <i class="bi bi-hourglass-split me-1"></i> قيد المراجعة
                      </span>
                  <?php else: ?>
                      <div class="dropdown">
                          <button class="btn btn-link text-muted p-0" data-bs-toggle="dropdown"><i class="bi bi-three-dots-vertical"></i></button>
                          <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                              <li><a class="dropdown-item" href="<?php echo e(route('campaigns.show', $c)); ?>"><i class="bi bi-eye me-2 opacity-50"></i> عرض</a></li>
                              <?php if(auth()->check()): ?>
                                <li><a class="dropdown-item text-warning" href="<?php echo e(route('campaigns.edit', $c)); ?>"><i class="bi bi-pencil me-2 opacity-50"></i> طلب تعديل</a></li>
                                <li>
                                    <button class="dropdown-item text-warning" onclick="openCancelModal('<?php echo e(route('campaigns.destroy', $c)); ?>')">
                                        <i class="bi bi-x-circle me-2 opacity-50"></i> طلب إلغاء
                                    </button>
                                </li>
                              <?php endif; ?>
                          </ul>
                      </div>
                  <?php endif; ?>
              </div>
            </div>
            
            <div class="mb-3">
              <?php if($c->status === 'active'): ?>
                <span class="badge bg-success-subtle text-success border border-success-subtle px-3 py-2 rounded-pill">
                    <i class="bi bi-check-circle me-1"></i> نشط
                </span>
              <?php else: ?>
                <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle px-3 py-2 rounded-pill">
                    <i class="bi bi-archive me-1"></i> مؤرشف
                </span>
              <?php endif; ?>
            </div>

            <div class="d-flex align-items-center justify-content-between pt-3 border-top text-muted small">
                <div>
                   <i class="bi bi-calendar-event me-1"></i> البداية: <?php echo e($c->start_date?->format('Y-m-d') ?? '—'); ?>

                </div>
                <div>
                   <i class="bi bi-calendar-check me-1"></i> النهاية: <?php echo e($c->end_date?->format('Y-m-d') ?? '—'); ?>

                </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
  <div class="mt-4"><?php echo e($campaigns->links()); ?></div>
<?php $__env->stopSection(); ?>


<div class="modal fade" id="cancelModal" tabindex="-1">
    <div class="modal-dialog">
        <form id="cancelForm" method="POST" class="modal-content">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <div class="modal-header">
                <h5 class="modal-title text-warning">طلب إلغاء</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من رغبتك في إرسال طلب إلغاء لهذا الحملة؟</p>
                <div class="mb-3">
                    <label class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                    <textarea name="reason" class="form-control" rows="3" placeholder="اكتب سبب الإلغاء هنا... - مطلوب" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">تراجع</button>
                <button type="submit" class="btn btn-warning">إرسال الطلب</button>
            </div>
        </form>
    </div>
</div>

<script>
    function openCancelModal(actionUrl) {
        document.getElementById('cancelForm').action = actionUrl;
        new bootstrap.Modal(document.getElementById('cancelModal')).show();
    }
</script>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/campaigns/index.blade.php ENDPATH**/ ?>