<?php $__env->startSection('content'); ?>
    
    <div class="page-header">
        <h4 class="mb-0">
            <i class="bi bi-person-gear text-primary"></i>
            تعديل المستخدم
        </h4>
        <a href="<?php echo e(route('users.show', $user)); ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-right me-1"></i> رجوع
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('users.update', $user)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                <div class="row g-3">
                    <div class="col-md-6"><label class="form-label">الاسم</label><input name="name" class="form-control"
                            value="<?php echo e($user->name); ?>"></div>
                    <div class="col-md-6"><label class="form-label">البريد</label><input name="email" type="email"
                            class="form-control" value="<?php echo e($user->email); ?>"></div>
                    <div class="col-md-6">
                        <label class="form-label">كلمة المرور (اختياري)</label>
                        <div class="input-group">
                            <input name="password" type="password" class="form-control" id="password-input">
                            <button class="btn btn-outline-secondary" type="button" onclick="togglePassword()">
                                <i class="bi bi-eye" id="toggle-icon"></i>
                            </button>
                        </div>
                    </div>
                    <script>
                        function togglePassword() {
                            const passwordInput = document.getElementById('password-input');
                            const toggleIcon = document.getElementById('toggle-icon');
                            if (passwordInput.type === 'password') {
                                passwordInput.type = 'text';
                                toggleIcon.classList.remove('bi-eye');
                                toggleIcon.classList.add('bi-eye-slash');
                            } else {
                                passwordInput.type = 'password';
                                toggleIcon.classList.remove('bi-eye-slash');
                                toggleIcon.classList.add('bi-eye');
                            }
                        }
                    </script>
                    <div class="col-md-6"><label class="form-label">الهاتف</label><input name="phone" class="form-control"
                            value="<?php echo e($user->phone); ?>"></div>
                    <div class="col-md-6"><label class="form-label">القسم</label><input name="department"
                            class="form-control" value="<?php echo e($user->department); ?>"></div>
                    <div class="col-md-6"><label class="form-label">المسمى الوظيفي</label><input name="job_title"
                            class="form-control" value="<?php echo e($user->job_title); ?>"></div>
                    <div class="col-md-6"><label class="form-label">الراتب</label><input name="salary" type="number"
                            step="0.01" class="form-control" value="<?php echo e($user->salary); ?>"></div>
                    <div class="col-md-6"><label class="form-label">تاريخ الانضمام</label><input name="join_date"
                            type="date" class="form-control" value="<?php echo e($user->join_date); ?>"></div>
                    <div class="col-md-6"><label class="form-label">الرصيد السنوي لطلب الإجازات</label><input name="annual_leave_quota"
                            type="number" class="form-control" value="<?php echo e($user->annual_leave_quota ?? 21); ?>"></div>
                    <div class="col-md-6"><label class="form-label">رصيد الإجازات الحالي</label><input name="leave_balance"
                            type="number" class="form-control" value="<?php echo e($user->leave_balance ?? 21); ?>"></div>

                    <div class="col-md-6"><label class="form-label">تاريخ بداية العقد</label><input
                            name="contract_start_date" type="date" class="form-control"
                            value="<?php echo e($user->contract_start_date ? $user->contract_start_date->format('Y-m-d') : ''); ?>">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">تاريخ نهاية العقد</label>
                        <input name="contract_end_date" type="date" class="form-control"
                            value="<?php echo e($user->contract_end_date ? $user->contract_end_date->format('Y-m-d') : ''); ?>">
                        <div class="form-text text-info">
                            <i class="bi bi-info-circle me-1"></i>
                            ملاحظة: سيتم إرسال إشعار قبل نهاية العقد بـ 60 يوم
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">الصورة الشخصية</label>
                        <input type="file" name="profile_photo" class="form-control" accept="image/*">
                        <?php if($user->profile_photo_path): ?>
                            <div class="mt-2">
                                <img src="<?php echo e(asset('storage/' . $user->profile_photo_path)); ?>" alt="Current Photo"
                                    class="img-thumbnail" style="height: 100px;">
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">صورة العقد</label>
                        <input type="file" name="contract_image" class="form-control" accept="image/*">
                        <?php if($user->contract_image): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $user->contract_image)); ?>" target="_blank">عرض صورة العقد
                                    الحالية</a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">صورة الفيش الجنائي</label>
                        <input type="file" name="criminal_record_image" class="form-control" accept="image/*">
                        <?php if($user->criminal_record_image): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $user->criminal_record_image)); ?>" target="_blank">عرض صورة الفيش
                                    الحالية</a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">صورة البطاقة الشخصية</label>
                        <input type="file" name="id_card_image" class="form-control" accept="image/*">
                        <?php if($user->id_card_image): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $user->id_card_image)); ?>" target="_blank">عرض صورة البطاقة
                                    الحالية</a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <label class="form-label mb-0">الأدوار</label>
                            <a href="<?php echo e(route('roles.index')); ?>" target="_blank" class="small text-decoration-none"><i
                                    class="bi bi-gear"></i> إدارة الأدوار</a>
                        </div>
                        <div class="card p-3 bg-body-tertiary" style="max-height: 200px; overflow-y: auto;">
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" name="roles[]" value="<?php echo e($r->id); ?>"
                                        id="role_<?php echo e($r->id); ?>" <?php if($user->roles->contains($r->id)): echo 'checked'; endif; ?>>
                                    <label class="form-check-label" for="role_<?php echo e($r->id); ?>">
                                        <?php echo e($r->name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-check"><input class="form-check-input" type="checkbox" name="active" value="1"
                                <?php if($user->active): echo 'checked'; endif; ?>><label class="form-check-label">نشط</label></div>
                    </div>
                </div>
                <div class="d-flex gap-2 justify-content-end mt-4">
                    <a href="<?php echo e(route('users.show', $user)); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg me-1"></i> إلغاء
                    </a>
                    <button class="btn btn-primary">
                        <i class="bi bi-check-lg me-1"></i> حفظ التغييرات
                    </button>
                </div>
            </form>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/users/edit.blade.php ENDPATH**/ ?>