

<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<div class="share-opinion-page">
    <div class="premium-hero-sleek">
        <div class="hero-bg-visuals">
            <div class="glow-orb-1" style="background: #0ea5e9;"></div>
            <div class="glow-orb-2" style="background: #2563eb;"></div>
            <div class="noise-overlay"></div>
        </div>
        <div class="hero-content-wrapper container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-8 animate-reveal-right text-end">
                    <nav aria-label="breadcrumb" class="mb-4 d-flex justify-content-end">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="text-white-50 decoration-none">لوحة التحكم</a></li>
                            <li class="breadcrumb-item active text-white" aria-current="page">شاركنا برأيك</li>
                        </ol>
                    </nav>
                    <div class="d-flex align-items-center justify-content-end gap-3 mb-3">
                        <div class="badge-glass-premium">
                            <i class="bi bi-chat-quote-fill me-2"></i> آراء ومقترحات المجتمع
                        </div>
                    </div>
                    <h1 class="display-4 fw-800 text-white mb-3 text-end">شاركنا برأيك</h1>
                    <p class="lead text-white-50 mb-0 max-w-600 ms-auto me-0 text-end">
                        إدارة تقييمات المستفيدين ومراجعة آراء المتبرعين والمتطوعين
                    </p>
                </div>
                <div class="col-lg-4 text-start mt-4 mt-lg-0 animate-reveal-left">
                    <button class="btn btn-action-glow rounded-pill px-5 py-3 fw-bold shadow-lg" data-bs-toggle="modal" data-bs-target="#addTestimonial">
                        <i class="bi bi-plus-lg me-2"></i> إضافة رأي جديد
                    </button>
                </div>
            </div>
        </div>
    </div>

<div class="container-fluid py-4">
    
    <div class="row g-4 mb-5">
        <div class="col-lg-12">
            <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card overflow-hidden border-0 shadow-sm animate-slide-up" style="background: rgba(255, 255, 255, 0.05); backdrop-filter: blur(10px);">
                <?php echo csrf_field(); ?>
                <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-dark bg-opacity-25">
                    <h5 class="mb-0 fw-bold text-white"><i class="bi bi-star-fill me-2 text-warning"></i> تقييمات المستفيدين (Beneficiary Evaluations)</h5>
                    <button type="submit" class="btn btn-sm btn-warning text-dark rounded-pill px-4 shadow-sm fw-bold">حفظ التقييمات</button>
                </div>
                <div class="p-4">
                    <div class="row g-3 text-dark">
                        
                        <div class="col-md-6 col-lg-3">
                            <div class="p-4 rounded-4 bg-white border text-center statistics-box h-100 shadow-sm">
                                <label class="form-label x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0">تقييم إيجابي</label>
                                <input type="text" name="eval_positive_reviews_value" class="form-control form-control-sm text-center fw-bold border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_positive_reviews_value'] ?? '+500'); ?>">
                                <input type="text" name="eval_positive_reviews_label" class="form-control form-control-sm text-center x-small text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_positive_reviews_label'] ?? 'تقييم إيجابي'); ?>">
                                <div class="mt-2 d-flex align-items-center justify-content-center gap-2">
                                    <i class="bi <?php echo e($settings['eval_positive_reviews_icon'] ?? 'bi-hand-thumbs-up-fill'); ?> text-success fs-5"></i>
                                    <input type="text" name="eval_positive_reviews_icon" class="form-control form-control-xs text-center border-0 bg-transparent p-0" style="width: 100px; font-size: 10px;" value="<?php echo e($settings['eval_positive_reviews_icon'] ?? 'bi-hand-thumbs-up-fill'); ?>">
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3">
                            <div class="p-4 rounded-4 bg-white border text-center statistics-box h-100 shadow-sm">
                                <label class="form-label x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0">متوسط التقييم</label>
                                <input type="text" name="eval_average_rating_value" class="form-control form-control-sm text-center fw-bold border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_average_rating_value'] ?? '4.8'); ?>">
                                <input type="text" name="eval_average_rating_label" class="form-control form-control-sm text-center x-small text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_average_rating_label'] ?? 'متوسط التقييم'); ?>">
                                <div class="mt-2 d-flex align-items-center justify-content-center gap-2">
                                    <i class="bi <?php echo e($settings['eval_average_rating_icon'] ?? 'bi-star-fill'); ?> text-warning fs-5"></i>
                                    <input type="text" name="eval_average_rating_icon" class="form-control form-control-xs text-center border-0 bg-transparent p-0" style="width: 100px; font-size: 10px;" value="<?php echo e($settings['eval_average_rating_icon'] ?? 'bi-star-fill'); ?>">
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3">
                            <div class="p-4 rounded-4 bg-white border text-center statistics-box h-100 shadow-sm">
                                <label class="form-label x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0">نسبة الرضا</label>
                                <input type="text" name="eval_satisfaction_rate_value" class="form-control form-control-sm text-center fw-bold border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_satisfaction_rate_value'] ?? '98%'); ?>">
                                <input type="text" name="eval_satisfaction_rate_label" class="form-control form-control-sm text-center x-small text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_satisfaction_rate_label'] ?? 'نسبة الرضا'); ?>">
                                <div class="mt-2 d-flex align-items-center justify-content-center gap-2">
                                    <i class="bi <?php echo e($settings['eval_satisfaction_rate_icon'] ?? 'bi-pie-chart-fill'); ?> text-info fs-5"></i>
                                    <input type="text" name="eval_satisfaction_rate_icon" class="form-control form-control-xs text-center border-0 bg-transparent p-0" style="width: 100px; font-size: 10px;" value="<?php echo e($settings['eval_satisfaction_rate_icon'] ?? 'bi-pie-chart-fill'); ?>">
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3">
                            <div class="p-4 rounded-4 bg-white border text-center statistics-box h-100 shadow-sm">
                                <label class="form-label x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0">المستفيدين</label>
                                <input type="text" name="eval_total_beneficiaries_value" class="form-control form-control-sm text-center fw-bold border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_total_beneficiaries_value'] ?? '+10K'); ?>">
                                <input type="text" name="eval_total_beneficiaries_label" class="form-control form-control-sm text-center x-small text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['eval_total_beneficiaries_label'] ?? 'مستفيد'); ?>">
                                <div class="mt-2 d-flex align-items-center justify-content-center gap-2">
                                    <i class="bi <?php echo e($settings['eval_total_beneficiaries_icon'] ?? 'bi-people-fill'); ?> text-primary fs-5"></i>
                                    <input type="text" name="eval_total_beneficiaries_icon" class="form-control form-control-xs text-center border-0 bg-transparent p-0" style="width: 100px; font-size: 10px;" value="<?php echo e($settings['eval_total_beneficiaries_icon'] ?? 'bi-people-fill'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <div class="row g-4">
        <div class="col-lg-12">
            <div class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up">
                <div class="p-4 border-bottom bg-white bg-opacity-5 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold"><i class="bi bi-chat-quote-fill me-2 text-info"></i> الآراء الواردة</h5>
                </div>
                <div class="p-4">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="bg-light">
                                <tr>
                                    <th>قائل العبارة</th>
                                    <th>الدور (متبرع/متطوع)</th>
                                    <th>التعليق</th>
                                    <th class="text-center">التقييم</th>
                                    <th class="text-center">الحالة</th>
                                    <th class="text-center">الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="rounded-circle border overflow-hidden bg-light" style="width: 40px; height: 40px;">
                                                <?php if($testimonial->image_path): ?>
                                                    <img src="<?php echo e(asset('storage/' . $testimonial->image_path)); ?>" class="w-100 h-100 object-fit-cover">
                                                <?php else: ?>
                                                    <div class="w-100 h-100 d-flex align-items-center justify-content-center text-muted"><i class="bi bi-person"></i></div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="fw-bold"><?php echo e($testimonial->name); ?></div>
                                        </div>
                                    </td>
                                    <td><span class="badge bg-info-subtle text-info rounded-pill px-3"><?php echo e($testimonial->role); ?></span></td>
                                    <td><p class="mb-0 small text-muted" title="<?php echo e($testimonial->content); ?>"><?php echo e(\Illuminate\Support\Str::limit($testimonial->content, 60)); ?></p></td>
                                    <td class="text-center">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="bi bi-star-fill <?php echo e($i <= $testimonial->rating ? 'text-warning' : 'text-secondary opacity-25'); ?> small"></i>
                                        <?php endfor; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if($testimonial->status == 'approved'): ?>
                                            <span class="badge bg-success-subtle text-success rounded-pill px-3">منشور</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning-subtle text-warning rounded-pill px-3">في الانتظار</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex justify-content-center gap-2">
                                            <button class="btn btn-sm btn-outline-info rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#editTestimonial<?php echo e($testimonial->id); ?>">
                                                <i class="bi bi-pencil me-1"></i> تعديل
                                            </button>
                                            <form action="<?php echo e(route('website.testimonials.destroy', $testimonial)); ?>" method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger rounded-pill px-3">
                                                    <i class="bi bi-trash me-1"></i> حذف
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($testimonials->isEmpty()): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-5 text-muted"> لا توجد آراء مضافة حالياً </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addTestimonial" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('website.testimonials.store')); ?>" method="POST" enctype="multipart/form-data" class="modal-content glass-card border-0">
            <?php echo csrf_field(); ?>
            <div class="modal-header border-0">
                <h5 class="modal-title fw-bold">إضافة رأي جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="mb-3">
                    <label class="form-label small fw-bold">اسم الشخص</label>
                    <input type="text" name="name" class="form-control" required placeholder="مثلاً: محمد أحمد">
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الدور / الصفة (متطوع / متبرع / شريك)</label>
                    <input type="text" name="role" class="form-control" placeholder="مثلاً: متطوع متميز">
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الرأي / العبارة</label>
                    <textarea name="content" class="form-control" rows="4" required placeholder="اكتب الرأي هنا..."></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">التقييم</label>
                    <select name="rating" class="form-select">
                        <?php for($i = 5; $i >= 1; $i--): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?> نجوم</option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الصورة (اختياري)</label>
                    <input type="file" name="image" class="form-control">
                </div>
            </div>
            <div class="modal-footer border-0">
                <button type="submit" class="btn btn-primary rounded-pill px-5 shadow-sm fw-bold">حفظ ونشر</button>
            </div>
        </form>
    </div>
</div>


<?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editTestimonial<?php echo e($testimonial->id); ?>" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('website.testimonials.update', $testimonial)); ?>" method="POST" enctype="multipart/form-data" class="modal-content glass-card border-0">
            <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
            <div class="modal-header border-0">
                <h5 class="modal-title fw-bold">تعديل الرأي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="mb-3">
                    <label class="form-label small fw-bold">اسم الشخص</label>
                    <input type="text" name="name" class="form-control" required value="<?php echo e($testimonial->name); ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الدور / الصفة</label>
                    <input type="text" name="role" class="form-control" value="<?php echo e($testimonial->role); ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الرأي / العبارة</label>
                    <textarea name="content" class="form-control" rows="4" required><?php echo e($testimonial->content); ?></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">التقييم</label>
                    <select name="rating" class="form-select">
                        <?php for($i = 5; $i >= 1; $i--): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e($testimonial->rating == $i ? 'selected' : ''); ?>><?php echo e($i); ?> نجوم</option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">الحالة</label>
                    <select name="status" class="form-select">
                        <option value="approved" <?php echo e($testimonial->status == 'approved' ? 'selected' : ''); ?>>منشور (Approved)</option>
                        <option value="pending" <?php echo e($testimonial->status == 'pending' ? 'selected' : ''); ?>>قيد المراجعة (Pending)</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label small fw-bold">تغيير الصورة (اختياري)</label>
                    <input type="file" name="image" class="form-control">
                </div>
            </div>
            <div class="modal-footer border-0">
                <button type="submit" class="btn btn-primary rounded-pill px-5 shadow-sm fw-bold">تحديث</button>
            </div>
        </form>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<style>
.share-opinion-page {
    background: #f8fafc;
}

.premium-hero-sleek {
    position: relative;
    padding: 100px 0 80px;
    background: #0f172a;
    overflow: hidden;
    margin-bottom: 2rem;
}

.hero-bg-visuals {
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
    z-index: 1;
}

.glow-orb-1, .glow-orb-2 {
    position: absolute;
    width: 600px; height: 600px;
    border-radius: 50%;
    filter: blur(120px);
    opacity: 0.2;
}

.glow-orb-1 { top: -200px; left: -100px; }
.glow-orb-2 { bottom: -200px; right: -100px; }

.noise-overlay {
    position: absolute;
    inset: 0;
    background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E");
    opacity: 0.05;
    mix-blend-mode: overlay;
}

.hero-content-wrapper {
    position: relative;
    z-index: 2;
}

.badge-glass-premium {
    display: inline-flex;
    align-items: center;
    padding: 8px 16px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 50px;
    color: #fff;
    font-size: 0.9rem;
}

.btn-action-glow {
    background: linear-gradient(135deg, #0ea5e9 0%, #2563eb 100%);
    color: white;
    border: none;
    transition: all 0.3s ease;
}

.btn-action-glow:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(37, 99, 235, 0.4);
    color: white;
}

.glass-card {
    background: white;
    border-radius: 20px;
}

.statistics-box {
    transition: all 0.3s ease;
}

.statistics-box:hover {
    transform: translateY(-5px);
    border-color: #0ea5e9 !important;
}

.animate-reveal-right { animation: revealRight 1s ease forwards; }
.animate-reveal-left { animation: revealLeft 1s ease forwards; }
.animate-slide-up { animation: slideUp 0.8s ease forwards; }

@keyframes revealRight {
    from { opacity: 0; transform: translateX(50px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes revealLeft {
    from { opacity: 0; transform: translateX(-50px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/website/share_opinion.blade.php ENDPATH**/ ?>