<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginWebController;
use App\Http\Controllers\HrEvaluationWebController;
use App\Http\Controllers\GuestHouseWebController;
use App\Http\Controllers\DashboardWebController;
use App\Http\Controllers\DonorWebController;
use App\Http\Controllers\DonationWebController;
use App\Http\Controllers\WarehouseWebController;
use App\Http\Controllers\ItemWebController;
use App\Http\Controllers\InventoryTransactionWebController;
use App\Http\Controllers\BeneficiaryWebController;
use App\Http\Controllers\AccountWebController;
use App\Http\Controllers\JournalEntryWebController;
use App\Http\Controllers\ReportsWebController;
use App\Http\Controllers\UserWebController;
use App\Http\Controllers\RoleWebController;
use App\Http\Controllers\ComplaintWebController;
use App\Http\Controllers\VolunteerHourWebController;
use App\Http\Controllers\PayrollWebController;
use App\Http\Controllers\VolunteerAttendanceWebController;
use App\Http\Controllers\EmployeeAttendanceWebController;
use App\Http\Controllers\TaskWebController;
use App\Http\Controllers\VolunteerTaskWebController;
use App\Http\Controllers\EmployeeTaskWebController;
use App\Http\Controllers\VolunteerWebController;
use App\Http\Controllers\ProjectWebController;
use App\Http\Controllers\CampaignWebController;
use App\Http\Controllers\ExpenseWebController;
use App\Http\Controllers\AuditWebController;
use App\Http\Controllers\NotificationWebController;
use App\Http\Controllers\FinancialClosureWebController;
use App\Http\Controllers\AttachmentWebController;
use App\Http\Controllers\DelegateWebController;
use App\Http\Controllers\TravelRouteWebController;
use App\Http\Controllers\TripWebController;
use App\Http\Controllers\TreasuryController;
use App\Http\Controllers\WebsiteWebController;
use App\Http\Controllers\MobileContentController;
use App\Http\Controllers\LogisticsDashboardController;

/* |-------------------------------------------------------------------------- | Web Routes |-------------------------------------------------------------------------- | | Here is where you can register web routes for your application. These | routes are loaded by the RouteServiceProvider and all of them will | be assigned to the "web" middleware group. Make something great! | */

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('login', [LoginWebController::class , 'show'])->name('login');
Route::post('login', [LoginWebController::class , 'login'])->name('login.post');
Route::post('logout', [LoginWebController::class , 'logout'])->name('logout');

// DEV ROUTES (Debug only)
Route::get('dev/create-user', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $u = \App\Models\User::firstOrCreate(
    ['email' => 'admin@ensan.local'],
    ['name' => 'System Admin', 'password' => \Illuminate\Support\Facades\Hash::make('admin123'), 'is_employee' => true, 'active' => true]
    );
    // Ensure admin role
    $r = \App\Models\Role::firstOrCreate(['key' => 'admin'], ['name' => 'Administrator']);
    if (!$u->roles->contains($r->id))
        $u->roles()->attach($r->id);
    return "User created/checked: admin@ensan.local / admin123";
});

Route::get('dev/debug-permissions', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $user = auth()->user();
    if (!$user)
        return "Not logged in";

    $html = "<h1>User: {$user->name}</h1>";
    $html .= "<h2>Roles:</h2><ul>";
    foreach ($user->roles as $role) {
        $html .= "<li>{$role->name} ({$role->key})</li>";
    }
    $html .= "</ul>";

    $html .= "<h2>Direct Permissions:</h2><ul>";
    // Assuming you might have direct permissions, if implemented
    $html .= "</ul>";

    $html .= "<h2>All Permissions via Roles:</h2><ul>";
    foreach ($user->roles as $role) {
        foreach ($role->permissions as $perm) {
            $html .= "<li>{$perm->key} (via {$role->name})</li>";
        }
    }
    $html .= "</ul>";

    return $html;
});

Route::get('dev/force-fix-hr-perms', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $html = "<h1>Fixing HR Permissions...</h1>";

    // 1. Find or Create HR Role
    // We want specifically the one with key='hr'
    $hrRole = \App\Models\Role::where('key', 'hr')->first();
    if (!$hrRole) {
        $hrRole = \App\Models\Role::create(['key' => 'hr', 'name' => 'الموارد البشرية']);
        $html .= "Created HR role.<br>";
    }
    else {
        $html .= "Found HR role (ID: {$hrRole->id}).<br>";
    }

    // 2. Define permissions to attach
    $perms = ['hr.evaluations', 'roles.view'];

    foreach ($perms as $key) {
        // Find or create permission
        $p = \App\Models\Permission::firstOrCreate(['key' => $key], ['name' => $key]);

        // Check if attached
        if (!$hrRole->permissions->contains('id', $p->id)) {
            $hrRole->permissions()->attach($p->id);
            $html .= "Attached '$key' to HR role.<br>";
        }
        else {
            $html .= "'$key' is already attached to HR role.<br>";
        }
    }

    // 3. Clear cache if any (standard Laravel permission cache?)
    // app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions(); // If using Spatie

    return $html . "<br>Done. Please check 'Roles' page or try accessing the links.";
});

Route::get('/dev/debug-roles', function () {
    $user = auth()->user();
    if (!$user)
        return 'Not logged in';
    return [
    'user_id' => $user->id,
    'name' => $user->name,
    'roles_count' => $user->roles()->count(),
    'roles' => $user->roles->toArray(),
    'check_admin' => $user->hasRole('admin') ? 'YES' : 'NO'
    ];
});

Route::get('dev/fix-dynamic-perms', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $html = "<h1>Fixing Dynamic Permissions & Duplicates...</h1>";

    // 1. Deduplicate 'HR' role if exists
    // We want only 'hr' (lowercase key). If 'HR' (uppercase key) exists, merge or delete.
    $badHr = \App\Models\Role::where('key', 'HR')->first();
    $goodHr = \App\Models\Role::firstOrCreate(['key' => 'hr'], ['name' => 'الموارد البشرية']);

    if ($badHr && $badHr->id !== $goodHr->id) {
        $html .= "Found duplicate HR role (key='HR'). Merging users...<br>";
        foreach ($badHr->users as $u) {
            if (!$u->roles->contains($goodHr->id)) {
                $u->roles()->attach($goodHr->id);
                $html .= "Moved user {$u->name} to 'hr' role.<br>";
            }
        }
        // Move permissions?
        foreach ($badHr->permissions as $p) {
            if (!$goodHr->permissions->contains($p->id)) {
                $goodHr->permissions()->attach($p->id);
            }
        }
        $badHr->delete();
        $html .= "Deleted 'HR' role.<br>";
    }

    // 2. Ensure Admin specific permissions exist
    // 'audits.view', 'notifications.view'
    $adminPerms = ['audits.view', 'notifications.view'];
    $adminRole = \App\Models\Role::where('key', 'admin')->first();

    if ($adminRole) {
        foreach ($adminPerms as $k) {
            $p = \App\Models\Permission::firstOrCreate(['key' => $k], ['name' => $k]);
            if (!$adminRole->permissions->contains($p->id)) {
                $adminRole->permissions()->attach($p->id);
                $html .= "Attached '$k' to Admin.<br>";
            }
        }
    }

    return $html . "<br>Done.";
});

Route::get('dev/ensure-admin', function () {
    if (app()->environment('production')) {
        abort(404);
    }
    $user = auth()->user();
    if (!$user)
        return "Please login first.";

    $role = \App\Models\Role::firstOrCreate(['key' => 'admin'], ['name' => 'Administrator']);

    if (!$user->roles->contains($role->id)) {
        $user->roles()->attach($role->id);
    }

    // Ensure admin has all permissions
    $perms = \App\Models\Permission::all();
    $role->permissions()->sync($perms->pluck('id'));

    return "User {$user->name} is now an Admin with all permissions.";
});

Route::get('dev/debug-ibrahim', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    // Try to find the user from the screenshot name
    $user = \App\Models\User::where('name', 'LIKE', '%ابراهيم%')->first();

    if (!$user) {
        return "User 'Ibrahim' not found. Users: <br>" . \App\Models\User::pluck('name')->implode('<br>');
    }

    $html = "<h1>User: {$user->name} (ID: {$user->id})</h1>";

    // --- FIX LOGIC START ---
    $html .= "<h2>Applying Fixes...</h2>";

    // 1. Ensure HR Role exists and has permissions
    $hr = \App\Models\Role::firstOrCreate(['key' => 'hr'], ['name' => 'الموارد البشرية']);
    $perms = ['hr.evaluations', 'roles.view'];
    foreach ($perms as $key) {
        $p = \App\Models\Permission::firstOrCreate(['key' => $key], ['name' => $key]);
        if (!$hr->permissions->contains('id', $p->id)) {
            $hr->permissions()->attach($p->id);
            $html .= "Attached permission '$key' to HR role.<br>";
        }
        else {
            $html .= "Permission '$key' already attached to HR role.<br>";
        }
    }

    // 2. Assign HR role to User if not present
    // Also ensure no other conflicting roles if necessary, but appending is safer usually.
    // However, if he has NO roles, appending is perfect.
    if (!$user->roles->contains('id', $hr->id)) {
        $user->roles()->attach($hr->id);
        $html .= "<strong>ASSIGNED 'hr' ROLE TO USER.</strong><br>";
        // Refresh user relation
        $user->load('roles.permissions');
    }
    else {
        $html .= "User already has 'hr' role.<br>";
    }
    // --- FIX LOGIC END ---

    $html .= "<h2>Current Roles:</h2><ul>";
    foreach ($user->roles as $r) {
        $html .= "<li>{$r->name} ({$r->key})</li>";
    }
    $html .= "</ul>";

    $html .= "<h2>Permissions Check:</h2>";
    $checks = ['hr.evaluations', 'roles.view'];
    foreach ($checks as $key) {
        $has = $user->hasPermission($key);
        $html .= "{$key}: " . ($has ? '<span style="color:green">YES</span>' : '<span style="color:red">NO</span>') . "<br>";
    }

    return $html;
});

Route::get('dev/make-ibrahim-manager', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    // Find Ibrahim Elfil
    $user = \App\Models\User::where('name', 'LIKE', '%ابراهيم%')->first();
    if (!$user) {
        $user = \App\Models\User::where('name', 'LIKE', '%الفيل%')->first();
    }
    if (!$user) {
        return "User 'Ibrahim Elfil' not found. Users: <br>" . \App\Models\User::pluck('name')->implode('<br>');
    }

    // Get or create manager role
    $managerRole = \App\Models\Role::firstOrCreate(['key' => 'manager'], ['name' => 'مدير المؤسسة']);

    // Assign role if not already assigned
    if (!$user->roles->contains('id', $managerRole->id)) {
        $user->roles()->attach($managerRole->id);
        return "SUCCESS: Assigned 'manager' role to user {$user->name} (ID: {$user->id}).<br>Please refresh the page now.";
    }

    return "User {$user->name} already has the 'manager' role. Current roles: " . $user->roles->pluck('key')->implode(', ');
});

Route::get('dev/ensure-marketer', function() {
    try {
        // Run PermissionSeeder
        $permSeeder = new \Database\Seeders\PermissionSeeder();
        $permSeeder->run();
        
        // Run MarketerRoleSeeder
        $marketerSeeder = new \Database\Seeders\MarketerRoleSeeder();
        $marketerSeeder->run();
        
        return "SUCCESS: Marketer role and permissions created/updated.<br>Role: 'marketer'<br>Demo User: 'marketer@ensan.local' (password: 'password')";
    } catch (\Throwable $e) {
        return "Error: " . $e->getMessage();
    }
});

Route::get('dev/test-project-create', function() {
    try {
        $p = \App\Models\Project::create([
            'name' => 'Test Project ' . now(),
            'status' => 'active',
            'fixed' => true
        ]);
        return "Project created ID: " . $p->id;
    } catch (\Throwable $e) {
        return "Error: " . $e->getMessage() . "<br><pre>" . $e->getTraceAsString() . "</pre>";
    }
});

Route::get('dev/test-project-list', function() {
    $projects = \App\Models\Project::withoutGlobalScopes()->get();
    return $projects;
});

Route::get('dev/migrate-inventory-schema', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    $output = "<h1>Migrating Inventory Schema...</h1>";

    try {
        // 1. Add 'notes' column
        if (!\Illuminate\Support\Facades\Schema::hasColumn('inventory_transactions', 'notes')) {
            \Illuminate\Support\Facades\Schema::table('inventory_transactions', function ($table) {
                            $table->text('notes')->nullable()->after('reference');
                        }
                        );
                        $output .= "Added 'notes' column.<br>";
                    }
                    else {
                        $output .= "'notes' column already exists.<br>";
                    }

                    // 2. Add 'related_transaction_id' column
                    if (!\Illuminate\Support\Facades\Schema::hasColumn('inventory_transactions', 'related_transaction_id')) {
                        \Illuminate\Support\Facades\Schema::table('inventory_transactions', function ($table) {
                            $table->unsignedBigInteger('related_transaction_id')->nullable()->after('id');
                            $table->index('related_transaction_id');
                        }
                        );
                        $output .= "Added 'related_transaction_id' column.<br>";
                    }
                    else {
                        $output .= "'related_transaction_id' column already exists.<br>";
                    }

                    // 3. Modify 'type' column
                    // Check current driver
                    $driver = \Illuminate\Support\Facades\DB::connection()->getDriverName();
                    $output .= "DB Driver: $driver<br>";

                    if ($driver === 'mysql') {
                        \Illuminate\Support\Facades\DB::statement("ALTER TABLE inventory_transactions MODIFY COLUMN type VARCHAR(50)");
                        $output .= "Modified 'type' column to VARCHAR(50) (MySQL).<br>";
                    }
                    else if ($driver === 'sqlite') {
                        $output .= "SQLite detected. Columns are typeless/text usually. Skipping ALTER.<br>";
                    }
                    else {
                        $output .= "Unknown driver. Skipping ALTER.<br>";
                    }

                }
                catch (\Exception $e) {
                    $output .= "Error: " . $e->getMessage();
                }

                return $output;
            });
Route::get('dev/migrate-leaves', function () {
    if (app()->environment('production')) {
        abort(404);
    }

    if (\Illuminate\Support\Facades\Schema::hasTable('leaves')) {
        return "Table 'leaves' already exists.";
    }

    \Illuminate\Support\Facades\Schema::create('leaves', function (\Illuminate\Database\Schema\Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->enum('type', ['annual', 'sick', 'unpaid', 'emergency', 'other'])->default('annual');
            $table->date('start_date');
            $table->date('end_date');
            $table->text('reason')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->foreignId('approved_by')->nullable()->constrained('users')->nullOnDelete();
            $table->text('rejection_reason')->nullable();
            $table->timestamps();
        }
        );

        return "Table 'leaves' created successfully.";
    });

Route::get('dev/migrate-purchases', function () {
    if (app()->environment('production'))
        abort(404);

    $output = "";

    if (!\Illuminate\Support\Facades\Schema::hasTable('suppliers')) {
        \Illuminate\Support\Facades\Schema::create('suppliers', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->id();
                    $table->string('name');
                    $table->string('phone')->nullable();
                    $table->string('website')->nullable();
                    $table->text('address')->nullable();
                    $table->timestamps();
                }
                );
                $output .= "Table 'suppliers' created.<br>";
            }
            else {
                $output .= "Table 'suppliers' already exists.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasTable('purchases')) {
                \Illuminate\Support\Facades\Schema::create('purchases', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->id();
                    $table->foreignId('supplier_id')->constrained('suppliers')->onDelete('cascade');
                    $table->string('item_name');
                    $table->integer('quantity')->default(1);
                    $table->decimal('original_price', 10, 2);
                    $table->decimal('discount_percentage', 5, 2)->default(0);
                    $table->decimal('final_price', 10, 2);
                    $table->date('purchase_date');
                    $table->text('notes')->nullable();
                    $table->timestamps();
                }
                );
                $output .= "Table 'purchases' created.<br>";
            }
            else {
                $output .= "Table 'purchases' already exists.<br>";
            }

            return $output;
        });

Route::get('dev/migrate-users-docs', function () {
    if (app()->environment('production'))
        abort(404);

    $output = "";

    if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'contract_image')) {
        \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->string('contract_image')->nullable();
                }
                );
                $output .= "Added 'contract_image' to users.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'criminal_record_image')) {
                \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->string('criminal_record_image')->nullable();
                }
                );
                $output .= "Added 'criminal_record_image' to users.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'id_card_image')) {
                \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->string('id_card_image')->nullable();
                }
                );
                $output .= "Added 'id_card_image' to users.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'contract_start_date')) {
                \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->date('contract_start_date')->nullable();
                    $table->date('contract_end_date')->nullable();
                }
                );
                $output .= "Added 'contract_start_date' and 'contract_end_date' to users.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasColumn('items', 'original_price')) {
                \Illuminate\Support\Facades\Schema::table('items', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->decimal('original_price', 10, 2)->nullable()->after('unit');
                    $table->decimal('discount_percentage', 5, 2)->default(0)->after('original_price');
                }
                );
                $output .= "Added 'original_price' and 'discount_percentage' to items.<br>";
            }

            return $output;
        });

Route::get('dev/migrate-leave-balance', function () {
    if (app()->environment('production'))
        abort(404);

    $output = "";

    if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'annual_leave_quota')) {
        \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->integer('annual_leave_quota')->default(21)->after('job_title');
                }
                );
                $output .= "Added 'annual_leave_quota' to users.<br>";
            }

            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'leave_balance')) {
                \Illuminate\Support\Facades\Schema::table('users', function (\Illuminate\Database\Schema\Blueprint $table) {
                    $table->integer('leave_balance')->default(21)->after('annual_leave_quota');
                }
                );
                $output .= "Added 'leave_balance' to users.<br>";
            }

            // Initialize balances for existing users
            $users = \App\Models\User::all();
            foreach ($users as $u) {
                $taken = \App\Models\Leave::where('user_id', $u->id)
                    ->where('status', 'approved')
                    ->where('type', '!=', 'unpaid')
                    ->get()
                    ->sum(function ($l) {
                return $l->days;
            }
            );
            $u->update(['leave_balance' => ($u->annual_leave_quota ?? 21) - $taken]);
        }

        return $output . "Done and balances initialized.";
    });









Route::middleware([\App\Http\Middleware\WebAuth::class , \App\Http\Middleware\RoleAccess::class])->group(function () {
    Route::get('dashboard', [DashboardWebController::class , 'index'])->name('dashboard.index');
    Route::get('notifications', [NotificationWebController::class , 'index'])->name('notifications.index');
    Route::get('audits', [AuditWebController::class , 'index'])->name('audits.index');
    Route::resource('donors', DonorWebController::class);
    Route::get('donations/export', [DonationWebController::class , 'export'])->name('donations.export');
    Route::resource('donations', DonationWebController::class);
    Route::resource('warehouses', WarehouseWebController::class);
    Route::resource('items', ItemWebController::class);
    Route::get('inventory-transactions/transfer', [InventoryTransactionWebController::class , 'createTransfer'])->name('inventory-transactions.create-transfer');
    Route::post('inventory-transactions/transfer', [InventoryTransactionWebController::class , 'storeTransfer'])->name('inventory-transactions.store-transfer');
    Route::get('inventory-transactions/reconcile', [InventoryTransactionWebController::class , 'createReconcile'])->name('inventory-transactions.create-reconcile');
    Route::post('inventory-transactions/reconcile', [InventoryTransactionWebController::class , 'storeReconcile'])->name('inventory-transactions.store-reconcile');
    Route::resource('inventory-transactions', InventoryTransactionWebController::class);
    Route::get('beneficiaries/export', [BeneficiaryWebController::class , 'export'])->name('beneficiaries.export');
    Route::post('beneficiaries/bulk', [BeneficiaryWebController::class , 'bulkUpdate'])->name('beneficiaries.bulk');
    Route::resource('beneficiaries', BeneficiaryWebController::class);
    Route::get('accounts/dashboard/overview', [AccountWebController::class , 'dashboard'])->name('accounts.dashboard');
    Route::resource('accounts', AccountWebController::class);

    // Treasuries
    Route::get('treasuries/sync-accounts', [TreasuryController::class , 'syncAccounts'])->name('treasuries.syncAccounts');
    Route::get('treasuries/dashboard', [TreasuryController::class , 'dashboard'])->name('treasuries.dashboard');
    Route::get('treasuries/export', [TreasuryController::class , 'export'])->name('treasuries.export');
    Route::post('treasuries/{treasury}/transactions', [TreasuryController::class , 'addTransaction'])->name('treasuries.addTransaction');
    Route::resource('treasuries', TreasuryController::class);

    Route::resource('journal-entries', JournalEntryWebController::class);

    Route::get('expenses/export', [ExpenseWebController::class , 'export'])->name('expenses.export');
    Route::resource('expenses', ExpenseWebController::class);

    // Revenue & Income Analytics
    Route::get('revenues', [\App\Http\Controllers\RevenueWebController::class , 'index'])->name('revenues.index');

    // New HR Dashboard
    Route::get('hr/dashboard', [\App\Http\Controllers\HrDashboardWebController::class , 'index'])->name('hr.dashboard');

    Route::get('finance/closures', [FinancialClosureWebController::class , 'index'])->name('closures.index');
    Route::get('finance/closures/create', [FinancialClosureWebController::class , 'create'])->name('closures.create');
    Route::post('finance/closures', [FinancialClosureWebController::class , 'store'])->name('closures.store');
    Route::get('finance/closures/{closure}', [FinancialClosureWebController::class , 'show'])->name('closures.show');
    Route::get('finance/closures/{closure}/edit', [FinancialClosureWebController::class , 'edit'])->name('closures.edit');
    Route::put('finance/closures/{closure}', [FinancialClosureWebController::class , 'update'])->name('closures.update');
    Route::delete('finance/closures/{closure}', [FinancialClosureWebController::class , 'destroy'])->name('closures.destroy');
    Route::post('finance/closures/{closure}/approve', [FinancialClosureWebController::class , 'approve'])->name('closures.approve');
    Route::post('attachments', [AttachmentWebController::class , 'store'])->name('attachments.store');
    Route::delete('attachments/{attachment}', [AttachmentWebController::class , 'destroy'])->name('attachments.destroy');
    Route::get('delegates/export', [DelegateWebController::class , 'export'])->name('delegates.export');
    Route::post('delegates/bulk', [DelegateWebController::class , 'bulkUpdate'])->name('delegates.bulk');
    Route::post('delegates/{delegate}/trips', [DelegateWebController::class , 'storeTrip'])->name('delegates.storeTrip');
    Route::delete('delegates/{delegate}/trips/{trip}', [DelegateWebController::class , 'destroyTrip'])->name('delegates.destroyTrip');
    Route::patch('delegates/{delegate}/trips/{trip}', [DelegateWebController::class , 'updateTripStatus'])->name('delegates.updateTripStatus');

    // Logistics Dashboard & Advanced Features
    Route::get('logistics/dashboard', [LogisticsDashboardController::class , 'index'])->name('logistics.dashboard');
    Route::get('logistics/delegate/{delegate}/performance', [LogisticsDashboardController::class , 'delegatePerformance'])->name('logistics.delegatePerformance');

    Route::resource('delegates', DelegateWebController::class);
    Route::post('travel-routes/{travel_route}/cities', [TravelRouteWebController::class , 'addCity'])->name('travel-routes.addCity');
    Route::post('travel-routes/{travel_route}/trips', [TravelRouteWebController::class , 'addTrip'])->name('travel-routes.addTrip');
    Route::get('travel-routes/export', [TravelRouteWebController::class , 'export'])->name('travel-routes.export');
    Route::post('travel-routes/{travel_route}/duplicate', [TravelRouteWebController::class , 'duplicate'])->name('travel-routes.duplicate');
    Route::resource('travel-routes', TravelRouteWebController::class);
    Route::get('trips', [TripWebController::class , 'index'])->name('trips.index');
    Route::post('trips', [TripWebController::class , 'store'])->name('trips.store');
    Route::get('reports', [ReportsWebController::class , 'index'])->name('reports.index');
    Route::resource('users', UserWebController::class);
    Route::resource('roles', RoleWebController::class);
    Route::post('users/{user}/roles/{role}', [UserWebController::class , 'attachRole'])->name('users.attachRole');
    Route::delete('users/{user}/roles/{role}', [UserWebController::class , 'detachRole'])->name('users.detachRole');
    Route::resource('complaints', ComplaintWebController::class);
    Route::resource('volunteer-hours', VolunteerHourWebController::class);
    Route::get('payrolls/dashboard/overview', [PayrollWebController::class , 'dashboard'])->name('payrolls.dashboard');
    Route::post('payrolls/{payroll}/create-journal-entry', [PayrollWebController::class , 'createJournalEntry'])->name('payrolls.createJournalEntry');
    Route::resource('payrolls', PayrollWebController::class);
    Route::get('hr/evaluations', [HrEvaluationWebController::class , 'index'])->name('hr.evaluations');
    Route::resource('volunteer-attendance', VolunteerAttendanceWebController::class);
    Route::post('employee-attendance/check-in', [EmployeeAttendanceWebController::class , 'checkIn'])->name('employee-attendance.checkIn');
    Route::post('employee-attendance/check-out', [EmployeeAttendanceWebController::class , 'checkOut'])->name('employee-attendance.checkOut');

    // Bulk Actions
    Route::post('employee-attendance/bulk-destroy', [\App\Http\Controllers\EmployeeAttendanceWebController::class , 'bulkDestroy'])->name('employee-attendance.bulk-destroy');
    Route::post('leaves/bulk-destroy', [\App\Http\Controllers\LeaveWebController::class , 'bulkDestroy'])->name('leaves.bulk-destroy');

    Route::resource('employee-attendance', EmployeeAttendanceWebController::class);
    Route::resource('leaves', \App\Http\Controllers\LeaveWebController::class)->parameters(['leaves' => 'leave']);
    Route::resource('suppliers', \App\Http\Controllers\SupplierWebController::class);
    Route::post('suppliers/{supplier}/purchases', [\App\Http\Controllers\PurchaseWebController::class , 'store'])->name('suppliers.purchases.store');
    Route::delete('suppliers/{supplier}/purchases/{purchase}', [\App\Http\Controllers\PurchaseWebController::class , 'destroy'])->name('suppliers.purchases.destroy');

    Route::resource('visits', \App\Http\Controllers\VisitWebController::class);
    Route::resource('reception', \App\Http\Controllers\ReceptionWebController::class);

    Route::resource('tasks', TaskWebController::class);
    Route::resource('volunteer-tasks', VolunteerTaskWebController::class);
    Route::resource('employee-tasks', EmployeeTaskWebController::class);
    Route::resource('volunteers', VolunteerWebController::class);
    Route::get('volunteers/reports', [VolunteerWebController::class , 'reports'])->name('volunteers.reports');
    Route::resource('projects', ProjectWebController::class);
    Route::post('projects/{project}/manager', [ProjectWebController::class , 'setManager'])->name('projects.setManager');
    Route::post('projects/{project}/deputy', [ProjectWebController::class , 'setDeputy'])->name('projects.setDeputy');
    Route::post('projects/{project}/volunteers', [ProjectWebController::class , 'attachVolunteer'])->name('projects.attachVolunteer');
    Route::delete('projects/{project}/volunteers/{user}', [ProjectWebController::class , 'detachVolunteer'])->name('projects.detachVolunteer');
    Route::post('projects/{project}/monthly-volunteers', [ProjectWebController::class , 'storeMonthlyVolunteer'])->name('projects.storeMonthlyVolunteer');
    Route::delete('projects/{project}/monthly-volunteers/{monthlyVolunteer}', [ProjectWebController::class , 'destroyMonthlyVolunteer'])->name('projects.destroyMonthlyVolunteer');
    Route::post('projects/{project}/activities', [ProjectWebController::class , 'storeActivity'])->name('projects.storeActivity');
    Route::delete('projects/{project}/activities/{activity}', [ProjectWebController::class , 'destroyActivity'])->name('projects.destroyActivity');
    Route::resource('campaigns', CampaignWebController::class);
    Route::post('campaigns/{campaign}/manager', [CampaignWebController::class , 'setManager'])->name('campaigns.setManager');
    Route::post('campaigns/{campaign}/volunteers', [CampaignWebController::class , 'attachVolunteer'])->name('campaigns.attachVolunteer');
    Route::delete('campaigns/{campaign}/volunteers/{user}', [CampaignWebController::class , 'detachVolunteer'])->name('campaigns.detachVolunteer');
    Route::post('campaigns/{campaign}/daily-menus', [CampaignWebController::class , 'storeDailyMenu'])->name('campaigns.storeDailyMenu');
    Route::delete('campaigns/{campaign}/daily-menus/{dailyMenu}', [CampaignWebController::class , 'destroyDailyMenu'])->name('campaigns.destroyDailyMenu');
    Route::post('campaigns/{campaign}/monthly-volunteers', [CampaignWebController::class , 'storeMonthlyVolunteer'])->name('campaigns.storeMonthlyVolunteer');
    Route::delete('campaigns/{campaign}/monthly-volunteers/{monthlyVolunteer}', [CampaignWebController::class , 'destroyMonthlyVolunteer'])->name('campaigns.destroyMonthlyVolunteer');
    Route::resource('workspaces', \App\Http\Controllers\WorkspaceWebController::class);
    Route::post('workspaces/{workspace}/rentals', [\App\Http\Controllers\WorkspaceWebController::class , 'storeRental'])->name('workspaces.storeRental');
    Route::patch('workspaces/{workspace}/rentals/{rental}/status', [\App\Http\Controllers\WorkspaceWebController::class , 'updateRentalStatus'])->name('workspaces.updateRentalStatus');
    Route::delete('workspaces/{workspace}/rentals/{rental}', [\App\Http\Controllers\WorkspaceWebController::class , 'destroyRental'])->name('workspaces.destroyRental');
    Route::resource('guest-houses', GuestHouseWebController::class);
    Route::post('guest-houses/{guest_house}/manager', [GuestHouseWebController::class , 'setManager'])->name('guest-houses.setManager');
    Route::post('guest-houses/{guest_house}/volunteers', [GuestHouseWebController::class , 'attachVolunteer'])->name('guest-houses.attachVolunteer');
    Route::delete('guest-houses/{guest_house}/volunteers/{user}', [GuestHouseWebController::class , 'detachVolunteer'])->name('guest-houses.detachVolunteer');
    Route::post('guest-houses/{guest_house}/monthly-volunteers', [GuestHouseWebController::class , 'storeMonthlyVolunteer'])->name('guest-houses.storeMonthlyVolunteer');
    Route::delete('guest-houses/{guest_house}/monthly-volunteers/{monthlyVolunteer}', [GuestHouseWebController::class , 'destroyMonthlyVolunteer'])->name('guest-houses.destroyMonthlyVolunteer');
    Route::get('admin/change-requests', [\App\Http\Controllers\ChangeRequestWebController::class , 'index'])->name('change-requests.index');
    // --- Website Management Unit ---
    Route::group(['prefix' => 'admin/website', 'as' => 'website.'], function () {
            Route::get('/', [WebsiteWebController::class , 'content'])->name('content');

            // Board Members
            Route::get('/board', [WebsiteWebController::class , 'boardMembers'])->name('board.index');
            Route::post('/board', [WebsiteWebController::class , 'boardMemberStore'])->name('board.store');
            Route::match(['post', 'put'], '/board/{member}', [WebsiteWebController::class , 'boardMemberUpdate'])->name('board.update');
            Route::delete('/board/{member}', [WebsiteWebController::class , 'boardMemberDestroy'])->name('board.destroy');

            // Partners
            Route::get('/partners', [WebsiteWebController::class , 'partners'])->name('partners.index');
            Route::post('/partners', [WebsiteWebController::class , 'partnerStore'])->name('partners.store');
            Route::match(['post', 'put'], '/partners/{partner}', [WebsiteWebController::class , 'partnerUpdate'])->name('partners.update');
            Route::delete('/partners/{partner}', [WebsiteWebController::class , 'partnerDestroy'])->name('partners.destroy');

            // News
            Route::get('/news', [WebsiteWebController::class , 'news'])->name('news.index');
            Route::post('/news', [WebsiteWebController::class , 'newsStore'])->name('news.store');
            Route::match(['post', 'put'], '/news/{news}', [WebsiteWebController::class , 'newsUpdate'])->name('news.update');
            Route::delete('/news/{news}', [WebsiteWebController::class , 'newsDestroy'])->name('news.destroy');

            // Volunteer Wall (Leaders of Giving)
            Route::get('/volunteer-wall', [WebsiteWebController::class , 'volunteerWall'])->name('volunteer-wall.index');
            Route::post('/volunteer-wall', [WebsiteWebController::class , 'volunteerWallStore'])->name('volunteer-wall.store');
            Route::match(['post', 'put'], '/volunteer-wall/{leader}', [WebsiteWebController::class , 'volunteerWallUpdate'])->name('volunteer-wall.update');
            Route::delete('/volunteer-wall/{leader}', [WebsiteWebController::class , 'volunteerWallDestroy'])->name('volunteer-wall.destroy');

            // Bookings
            Route::get('/bookings', [WebsiteWebController::class , 'bookings'])->name('bookings.index');
            Route::patch('/bookings/{booking}', [WebsiteWebController::class , 'bookingUpdateStatus'])->name('bookings.update');

            // Volunteer Requests & Content
            Route::get('/volunteer-requests', [WebsiteWebController::class , 'volunteerRequests'])->name('volunteer-requests.index');
            Route::patch('/volunteer-requests/{request}/status', [WebsiteWebController::class , 'updateVolunteerRequestStatus'])->name('volunteer-requests.status');
            Route::delete('/volunteer-requests/{volunteerRequest}', [WebsiteWebController::class , 'destroyVolunteerRequest'])->name('volunteer-requests.destroy');
            Route::post('/volunteer-content', [WebsiteWebController::class , 'updateVolunteerContent'])->name('volunteer-content.update');

            // Contact Messages
            Route::get('/contact-messages', [WebsiteWebController::class , 'contactMessages'])->name('contact-messages.index');
            Route::patch('/contact-messages/{message}/read', [WebsiteWebController::class , 'contactMessageMarkRead'])->name('contact-messages.read');
            Route::delete('/contact-messages/{message}', [WebsiteWebController::class , 'contactMessageDestroy'])->name('contact-messages.destroy');
            Route::post('/contact-settings', [WebsiteWebController::class , 'updateContactSettings'])->name('contact-settings.update');

            // Dynamic Cards
            Route::get('/cards', [WebsiteWebController::class , 'cards'])->name('cards.index');
            Route::post('/cards', [WebsiteWebController::class , 'cardStore'])->name('cards.store');
            Route::match(['post', 'put'], '/cards/{card}', [WebsiteWebController::class , 'cardUpdate'])->name('cards.update');
            Route::delete('/cards/{card}', [WebsiteWebController::class , 'cardDestroy'])->name('cards.destroy');

            // Project/Campaign Content Update
            Route::post('/projects', [WebsiteWebController::class , 'storeProject'])->name('projects.store');
            Route::match(['post', 'put'], '/projects/{project}', [WebsiteWebController::class , 'updateProjectContent'])->name('projects.update');
            Route::delete('/projects/{project}', [WebsiteWebController::class , 'destroyProject'])->name('projects.destroy');
            Route::post('/projects-stats', [WebsiteWebController::class , 'updateProjectStats'])->name('projects.stats.update');
            Route::get('/campaigns-content', [WebsiteWebController::class , 'campaignsContent'])->name('campaigns.content');
            Route::post('/campaigns', [WebsiteWebController::class , 'storeCampaign'])->name('campaigns.store');
            Route::match(['post', 'put'], '/campaigns/{campaign}', [WebsiteWebController::class , 'updateCampaignContent'])->name('campaigns.update');
            Route::delete('/campaigns/{campaign}', [WebsiteWebController::class , 'destroyCampaign'])->name('campaigns.destroy');
            Route::post('/campaigns-stats', [WebsiteWebController::class , 'updateCampaignStats'])->name('campaigns.stats.update');

            // Guest House Content
            Route::get('/guest-house-content', [WebsiteWebController::class , 'guestHouseContent'])->name('guest-house.content');
            Route::post('/guest-house-content', [WebsiteWebController::class , 'guestHouseContentUpdate'])->name('guest-house.update');
            Route::post('/guest-house-stats', [WebsiteWebController::class , 'updateGuestHouseStats'])->name('guest-house.stats.update');
            Route::get('/guest-house-slider', [WebsiteWebController::class , 'guestHouseSlider'])->name('guest-house.slider');
            Route::get('/dummy-bookings', [WebsiteWebController::class , 'createDummyBookings'])->name('guest-house.dummy');

            // Headquarters/Branches
            Route::get('/headquarters', [WebsiteWebController::class , 'headquarters'])->name('headquarters.index');
            Route::post('/headquarters', [WebsiteWebController::class , 'updateHeadquarters'])->name('headquarters.update');
            Route::post('/headquarters/branches', [WebsiteWebController::class , 'branchStore'])->name('headquarters.branches.store');
            Route::put('/headquarters/branches/{branch}', [WebsiteWebController::class , 'branchUpdate'])->name('headquarters.branches.update');
            Route::delete('/headquarters/branches/{branch}', [WebsiteWebController::class , 'branchDestroy'])->name('headquarters.branches.destroy');

            // General Settings & Stats
            Route::get('/settings', [WebsiteWebController::class , 'showSettings'])->name('settings.index');
            Route::post('/settings', [WebsiteWebController::class , 'updateSettings'])->name('settings.update');

            // Testimonials
            Route::get('/testimonials', [WebsiteWebController::class , 'testimonials'])->name('testimonials.index');
            Route::post('/testimonials', [WebsiteWebController::class , 'testimonialStore'])->name('testimonials.store');
            Route::match(['post', 'put'], '/testimonials/{testimonial}', [WebsiteWebController::class , 'testimonialUpdate'])->name('testimonials.update');
            Route::delete('/testimonials/{testimonial}', [WebsiteWebController::class , 'testimonialDestroy'])->name('testimonials.destroy');

            Route::get('/share-opinion', [WebsiteWebController::class , 'shareOpinion'])->name('share-opinion.index');

            // Dynamic Pages (Management)
            Route::get('/pages', [WebsiteWebController::class , 'pages'])->name('pages.index');
            Route::post('/pages', [WebsiteWebController::class , 'pageStore'])->name('pages.store');
            Route::match(['post', 'put'], '/pages/{page}', [WebsiteWebController::class , 'pageUpdate'])->name('pages.update');
            Route::delete('/pages/{page}', [WebsiteWebController::class , 'pageDestroy'])->name('pages.destroy');
        }
        );

        // --- Mobile App Management Unit ---
        Route::group(['prefix' => 'admin/mobile', 'as' => 'mobile.'], function () {
            Route::get('/', [MobileContentController::class , 'index'])->name('dashboard');

            // Banners
            Route::get('/banners', [MobileContentController::class , 'bannersIndex'])->name('banners.index');
            Route::post('/banners', [MobileContentController::class , 'bannerStore'])->name('banners.store');
            Route::delete('/banners/{banner}', [MobileContentController::class , 'bannerDestroy'])->name('banners.destroy');

            // Notifications
            Route::get('/notifications', [MobileContentController::class , 'notificationsIndex'])->name('notifications.index');
            Route::post('/notifications', [MobileContentController::class , 'notificationStore'])->name('notifications.store');

            // Case Applications (from App)
            Route::get('/cases', [MobileContentController::class , 'casesIndex'])->name('cases.index');
            Route::patch('/cases/{application}', [MobileContentController::class , 'caseUpdateStatus'])->name('cases.update');

            // In-Kind Donations
            Route::get('/inkind', [MobileContentController::class , 'inKindDonationsIndex'])->name('inkind.index');
            Route::patch('/inkind/{donation}', [MobileContentController::class , 'inKindDonationUpdateStatus'])->name('inkind.update');

            // Project/Campaign Updates Mobile
            Route::put('/projects/{project}/mobile', [MobileContentController::class , 'updateProjectMobileContent'])->name('projects.update.mobile');
            Route::put('/campaigns/{campaign}/mobile', [MobileContentController::class , 'updateCampaignMobileContent'])->name('campaigns.update.mobile');
        }
        );

        Route::post('admin/change-requests/{changeRequest}/approve', [\App\Http\Controllers\ChangeRequestWebController::class , 'approve'])->name('change-requests.approve');
        Route::post('admin/change-requests/{changeRequest}/reject', [\App\Http\Controllers\ChangeRequestWebController::class , 'reject'])->name('change-requests.reject');
        Route::delete('admin/change-requests/{changeRequest}', [\App\Http\Controllers\ChangeRequestWebController::class , 'destroy'])->name('change-requests.destroy');
        Route::post('admin/change-requests/bulk-destroy', [\App\Http\Controllers\ChangeRequestWebController::class , 'bulkDestroy'])->name('change-requests.bulk-destroy');
        Route::post('admin/change-requests/bulk-revert', [\App\Http\Controllers\ChangeRequestWebController::class , 'bulkRevert'])->name('change-requests.bulk-revert');
        Route::post('admin/change-requests/{changeRequest}/revert', [\App\Http\Controllers\ChangeRequestWebController::class , 'revert'])->name('change-requests.revert');
        Route::post('admin/change-requests/{changeRequest}/cancel', [\App\Http\Controllers\ChangeRequestWebController::class , 'cancel'])->name('change-requests.cancel');
        Route::put('admin/change-requests/{changeRequest}', [\App\Http\Controllers\ChangeRequestWebController::class , 'update'])->name('change-requests.update');
    });
