@extends('layouts.app')

@section('content')
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<div class="guest-house-mgmt-page">
    {{-- Dynamic Hero Section --}}
    <div class="premium-hero-sleek" style="background: @if($page->image_path) linear-gradient(rgba(15, 23, 42, 0.8), rgba(30, 58, 138, 0.8)), url('{{ asset('storage/' . $page->image_path) }}') @else linear-gradient(135deg, #0f172a 0%, #1e3a8a 100%) @endif; background-size: cover; background-position: center;">
        <div class="hero-bg-visuals">
            <div class="glow-orb-1" style="background: #3b82f6;"></div>
            <div class="glow-orb-2" style="background: #0ea5e9;"></div>
            <div class="noise-overlay"></div>
        </div>
        
        <div class="hero-content-wrapper container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-8 animate-reveal-right text-end">
                    <div class="d-flex align-items-center justify-content-end gap-3 mb-3">
                        <div class="badge-glass-premium">
                            <i class="bi bi-hospital me-2"></i> إدارة دار الضيافة
                        </div>
                    </div>
                    <h1 class="display-3 fw-800 text-white mb-3 text-end">إدارة دار الضيافة</h1>
                    <p class="lead text-white-50 mb-0 max-w-600 ms-auto me-0 text-end">
                        محتوى الصفحة
                    </p>
                </div>
                <div class="col-lg-4 text-start mt-4 mt-lg-0 animate-reveal-left">
                    <button type="button" onclick="document.querySelector('#combinedSubmitForm').submit()" class="btn btn-action-glow-blue btn-lg px-5 py-3 rounded-4 shadow-xl">
                        <i class="bi bi-cloud-check-fill me-2"></i>
                        <span>حفظ التغييرات النهائية</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    {{-- Main Dashboard Area --}}
    <div class="container-fluid py-5">
        <div class="row g-4">
            {{-- Unified Form --}}
            <div class="col-12">
                <form id="combinedSubmitForm" action="{{ route('website.guest-house.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row g-4">
                        {{-- Basic Information Card --}}
                        <div class="col-12">
                            <div class="premium-card-dark animate-up h-100">
                                <div class="card-header-lux">
                                    <div class="header-icon bg-blue-500"><i class="bi bi-file-earmark-richtext"></i></div>
                                    <h5 class="fw-bold mb-0">المحتوى التعريفي والوصف</h5>
                                </div>
                                <div class="card-body-lux p-4 p-md-5">
                                    <div class="form-group-lux mb-4">
                                        <label class="label-lux">عنوان الصفحة الرئيسي</label>
                                        <div class="input-glow-wrapper">
                                            <input type="text" name="title" class="field-lux text-xl" value="{{ $page->title }}" required>
                                        </div>
                                    </div>
                                    <div class="form-group-lux mb-4">
                                        <label class="label-lux">العنوان الفرعي (Hero Subtitle)</label>
                                        <input type="text" name="gh_hero_subtitle" class="field-lux" value="{{ $settings['gh_hero_subtitle'] ?? 'ملاذ آمن للمرضى ومرافقيهم' }}">
                                    </div>

                                </div>
                            </div>
                        </div>





                        {{-- Stats & Gallery Unified Management --}}
                        <div class="col-12">
                            <div class="premium-card-dark animate-up">
                                <div class="card-header-lux d-flex justify-content-between align-items-center">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="header-icon bg-emerald-500"><i class="bi bi-columns-gap"></i></div>
                                        <h5 class="fw-bold mb-0">لوحة الإحصائيات ومعرض الصور</h5>
                                    </div>
                                </div>
                                <div class="card-body-lux p-4 p-md-5">
                                    {{-- Statistics Section --}}
                                    <h6 class="fw-bold text-white mb-4"><i class="bi bi-bar-chart-fill me-2 text-amber-500"></i> إحصائيات الدار</h6>
                                    <div class="row g-4 mb-5">
                                        {{-- Stat 1: Beds --}}
                                        <div class="col-md-3 col-6">
                                            <div class="stat-input-box">
                                                <div class="stat-icon-vibe bg-blue-500 bg-opacity-10 text-blue-500">
                                                    <i class="bi bi-hospital"></i>
                                                </div>
                                                <div class="w-100">
                                                    <input type="text" name="gh_stat1_value" class="stat-value-field" value="{{ $settings['gh_stat1_value'] ?? '+50' }}">
                                                    <input type="text" name="gh_stat1_label" class="stat-label-field" value="{{ $settings['gh_stat1_label'] ?? 'سرير' }}">
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Stat 2: Patients --}}
                                        <div class="col-md-3 col-6">
                                            <div class="stat-input-box">
                                                <div class="stat-icon-vibe bg-emerald-500 bg-opacity-10 text-emerald-500">
                                                    <i class="bi bi-people-fill"></i>
                                                </div>
                                                <div class="w-100">
                                                    <input type="text" name="gh_stat2_value" class="stat-value-field" value="{{ $settings['gh_stat2_value'] ?? '+3000' }}">
                                                    <input type="text" name="gh_stat2_label" class="stat-label-field" value="{{ $settings['gh_stat2_label'] ?? 'مريض سنوياً' }}">
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Stat 3: Branches --}}
                                        <div class="col-md-3 col-6">
                                            <div class="stat-input-box">
                                                <div class="stat-icon-vibe bg-amber-500 bg-opacity-10 text-amber-500">
                                                    <i class="bi bi-geo-alt-fill"></i>
                                                </div>
                                                <div class="w-100">
                                                    <input type="text" name="gh_stat3_value" class="stat-value-field" value="{{ $settings['gh_stat3_value'] ?? '2' }}">
                                                    <input type="text" name="gh_stat3_label" class="stat-label-field" value="{{ $settings['gh_stat3_label'] ?? 'فرع' }}">
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Stat 4: Reception --}}
                                        <div class="col-md-3 col-6">
                                            <div class="stat-input-box">
                                                <div class="stat-icon-vibe bg-indigo-500 bg-opacity-10 text-indigo-500">
                                                    <i class="bi bi-clock-history"></i>
                                                </div>
                                                <div class="w-100">
                                                    <input type="text" name="gh_stat4_value" class="stat-value-field" value="{{ $settings['gh_stat4_value'] ?? '24/7' }}">
                                                    <input type="text" name="gh_stat4_label" class="stat-label-field" value="{{ $settings['gh_stat4_label'] ?? 'استقبال' }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="divider-lux mb-5"></div>
                                    {{-- Slider Section --}}
                                    <h6 class="fw-bold text-white mb-4"><i class="bi bi-play-btn me-2 text-indigo-400"></i> سلايدر الصور المتحركة</h6>
                                    <div class="row g-4 mb-5">
                                        @for($i = 1; $i <= 10; $i++)
                                        <div class="col-md-4">
                                            <div class="gallery-card-lux position-relative" id="ghSliderZone{{ $i }}" style="height: 160px; border-color: #6366f1;">
                                                <input type="file" name="gh_slider_{{ $i }}" class="file-hidden" onchange="previewGhSlider(this, {{ $i }})">
                                                
                                                {{-- Delete Button --}}
                                                @if(isset($settings["gh_slider_$i"]))
                                                <button type="button" class="btn btn-danger btn-sm rounded-circle position-absolute top-0 end-0 m-2 shadow-lg" 
                                                        style="z-index: 20; width: 30px; height: 30px; padding: 0;"
                                                        onclick="event.stopPropagation(); document.getElementById('delete_gh_slider_{{ $i }}').value='1'; this.closest('.gallery-card-lux').querySelector('.gallery-preview-wrapper').innerHTML='<div class=\'gallery-placeholder\'><i class=\'bi bi-images fs-3 text-indigo-400\'></i><p class=\'x-small mb-0 mt-2\'>محذوف - حفظ لتنفيذ</p></div>'; this.remove();">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                                @endif
                                                <input type="hidden" name="delete_gh_slider_{{ $i }}" id="delete_gh_slider_{{ $i }}" value="0">

                                                <div class="gallery-preview-wrapper" id="ghSliderPreview{{ $i }}">
                                                    @if(isset($settings["gh_slider_$i"]))
                                                        <img src="{{ asset('storage/' . $settings["gh_slider_$i"]) }}" class="img-fluid rounded-4 h-100 w-100 object-fit-cover">
                                                    @else
                                                        <div class="gallery-placeholder">
                                                            <i class="bi bi-images fs-3 text-indigo-400"></i>
                                                            <p class="x-small mb-0 mt-2">شريحة {{ $i }}</p>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @endfor
                                    </div>

                                    <div class="divider-lux mb-5"></div>




                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Room Bookings Section (Added Request) --}}
    <div class="row mt-5">
        <div class="col-12">
            <div class="premium-card-dark animate-up">
                <div class="card-header-lux d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center gap-3">
                        <div class="header-icon bg-indigo-500"><i class="bi bi-calendar-check-fill"></i></div>
                        <h5 class="fw-bold mb-0">طلبات الحجز من الموقع</h5>
                    </div>
                </div>
                <div class="card-body-lux p-4">
                    {{-- Search Filter Section --}}


                    <div class="row g-4">
                        @forelse($bookings as $booking)
                        <div class="col-md-6 col-xl-4">
                            <div class="request-card-premium h-100">
                                <div class="card-status-pill">
                                    @php
                                        $statusClass = [
                                            'pending' => 'pending',
                                            'confirmed' => 'approved',
                                            'cancelled' => 'rejected'
                                        ][$booking->status] ?? 'pending';
                                        
                                        $statusText = [
                                            'pending' => 'قيد الانتظار',
                                            'confirmed' => 'مؤكد',
                                            'cancelled' => 'ملغي'
                                        ][$booking->status] ?? $booking->status;
                                    @endphp
                                    <span class="badge-status {{ $statusClass }}">{{ $statusText }}</span>
                                </div>

                                <div class="card-top-vibe mt-2">
                                    <div class="user-avatar-premium shadow-lg bg-indigo-600">
                                        <div class="avatar-ring"></div>
                                        <span class="avatar-initials"><i class="bi bi-person"></i></span>
                                    </div>
                                    <div class="user-main-info">
                                        <h6 class="fw-bold mb-1 text-white">{{ $booking->name }}</h6>
                                        <div class="x-small text-slate-400 d-flex gap-2">
                                            <span><i class="bi bi-phone me-1"></i>{{ $booking->phone }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-mid-vibe mt-4">
                                    <div class="detail-grid-compact">
                                        <div class="detail-item-compact">
                                            <label>الغرفة</label>
                                            <span>{{ $booking->room_type }}</span>
                                        </div>
                                        <div class="detail-item-compact">
                                            <label>المدة</label>
                                            <span>{{ \Carbon\Carbon::parse($booking->check_in)->diffInDays($booking->check_out) }} ليالي</span>
                                        </div>
                                        <div class="detail-item-compact w-100">
                                            <label>الوصول</label>
                                            <span class="text-emerald-400">{{ $booking->check_in }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-bottom-vibe mt-4 pt-3 border-top border-white border-opacity-10">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="text-slate-500 x-small fw-bold">#{{ $booking->id }}</span>
                                        <span class="text-slate-500 x-small">{{ $booking->created_at->format('d M Y') }}</span>
                                    </div>
                                    
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-glass-indigo flex-grow-1 py-2 rounded-pill x-small fw-bold" data-bs-toggle="modal" data-bs-target="#viewBooking{{ $booking->id }}">
                                            <i class="bi bi-eye ms-1"></i> التفاصيل
                                        </button>
                                        <div class="dropdown">
                                            <button class="btn btn-glass-indigo py-2 px-3 rounded-pill dropdown-toggle" data-bs-toggle="dropdown">
                                                <i class="bi bi-three-dots"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-2xl border-0 premium-dropdown-dark">
                                                <li>
                                                    <form action="{{ route('website.bookings.update', $booking) }}" method="POST">
                                                        @csrf @method('PATCH')
                                                        <input type="hidden" name="status" value="confirmed">
                                                        <button type="submit" class="dropdown-item text-success fw-bold x-small"><i class="bi bi-check-circle me-2"></i> تأكيد</button>
                                                    </form>
                                                </li>
                                                <li>
                                                    <form action="{{ route('website.bookings.update', $booking) }}" method="POST">
                                                        @csrf @method('PATCH')
                                                        <input type="hidden" name="status" value="cancelled">
                                                        <button type="submit" class="dropdown-item text-danger fw-bold x-small"><i class="bi bi-x-circle me-2"></i> إلغاء</button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="col-12">
                            <div class="empty-state-card-lux py-5 text-center">
                                <i class="bi bi-calendar-x fs-1 text-slate-600 mb-3 d-block"></i>
                                <p class="text-slate-400 mb-0">لا توجد طلبات حجز حالياً</p>
                            </div>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    @foreach($bookings as $booking)
    <div class="modal fade" id="viewBooking{{ $booking->id }}" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content premium-modal-dark shadow-2xl">
                <div class="modal-header border-0 p-4 pb-0">
                    <h5 class="modal-title fw-bold">تفاصيل طلب الحجز #{{ $booking->id }}</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="row g-4">
                        <div class="col-md-4">
                            <div class="info-strip-premium h-100 flex-column text-center justify-content-center gap-3">
                                <div class="strip-avatar bg-indigo-600 mx-auto" style="width: 80px; height: 80px; font-size: 2rem;">
                                    <i class="bi bi-person"></i>
                                </div>
                                <div>
                                    <h5 class="fw-bold text-white mb-1">{{ $booking->name }}</h5>
                                    <p class="mb-0 x-small text-slate-400">{{ $booking->phone }}</p>
                                    <p class="mb-0 x-small text-slate-400">{{ $booking->email }}</p>
                                    @if($booking->national_id)
                                    <span class="badge bg-slate-800 mt-2">{{ $booking->national_id }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="detail-box-lux mb-3">
                                <h6 class="text-indigo-400 fw-bold mb-3"><i class="bi bi-info-circle me-2"></i> تفاصيل الإقامة</h6>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <label class="detail-label-sleek">نوع الغرفة</label>
                                        <div class="detail-content-sleek">{{ $booking->room_type }}</div>
                                    </div>
                                    <div class="col-6">
                                        <label class="detail-label-sleek">المدة المتوقعة</label>
                                        <div class="detail-content-sleek">{{ $booking->expected_duration_arabic ?? '-' }}</div>
                                    </div>
                                    <div class="col-6">
                                        <label class="detail-label-sleek">تاريخ الوصول</label>
                                        <div class="detail-content-sleek">{{ $booking->arrival_date ?? $booking->check_in }}</div>
                                    </div>
                                    <div class="col-6">
                                        <label class="detail-label-sleek">المركز الطبي</label>
                                        <div class="detail-content-sleek">{{ $booking->medical_center ?? '-' }}</div>
                                    </div>
                                </div>
                            </div>
                            @if($booking->companion_name)
                            <div class="detail-box-lux">
                                <h6 class="text-emerald-400 fw-bold mb-3"><i class="bi bi-people me-2"></i> بيانات المرافق</h6>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <label class="detail-label-sleek">الاسم</label>
                                        <div class="detail-content-sleek">{{ $booking->companion_name }}</div>
                                    </div>
                                    <div class="col-6">
                                        <label class="detail-label-sleek">الهاتف</label>
                                        <div class="detail-content-sleek">{{ $booking->companion_phone }}</div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                        <div class="col-12">
                             <div class="detail-box-lux">
                                <h6 class="text-amber-400 fw-bold mb-3"><i class="bi bi-paperclip me-2"></i> المستندات المرفقة</h6>
                                <div class="d-flex flex-wrap gap-2">
                                     @php
                                        $docs = [
                                            ['label' => 'بطاقة المريض', 'path' => $booking->patient_id_path],
                                            ['label' => 'بطاقة المرافق', 'path' => $booking->companion_id_path],
                                            ['label' => 'تحويل المستشفى', 'path' => $booking->medical_transfer_path],
                                            ['label' => 'كارت المتابعة', 'path' => $booking->followup_card_path],
                                            ['label' => 'تقرير الإشعاع', 'path' => $booking->medical_report_path],
                                        ];
                                    @endphp
                                    @foreach($docs as $doc)
                                        @if($doc['path'])
                                            <a href="{{ asset('storage/' . $doc['path']) }}" target="_blank" class="btn btn-glass-indigo btn-sm">
                                                <i class="bi bi-file-earmark-image me-2"></i> {{ $doc['label'] }}
                                            </a>
                                        @endif
                                    @endforeach
                                    @if(collect($docs)->where('path', '!=', null)->isEmpty())
                                        <span class="text-slate-500 x-small">لا توجد مرفقات</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 p-4">
                    <button type="button" class="btn btn-glass-indigo px-5 rounded-pill" data-bs-dismiss="modal">إغلاق</button>
                </div>
            </div>
        </div>
    </div>
    @endforeach

</div>

<script>
function previewMain(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('previewMainImg');
            if (preview) {
                preview.src = e.target.result;
            } else {
                const container = document.querySelector('.preview-area-lux-large');
                container.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded-4 shadow-2xl" id="previewMainImg">`;
            }
        }
        reader.readAsDataURL(input.files[0]);
    }
}

function previewGallery(input, id) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            const container = document.getElementById('galleryPreviewContainer' + id);
            container.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded-4 h-100 w-100 object-fit-cover shadow-lg">`;
        }
        reader.readAsDataURL(input.files[0]);
    }
}

function previewGhSlider(input, id) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            const container = document.getElementById('ghSliderPreview' + id);
            container.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded-4 h-100 w-100 object-fit-cover">`;
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

<style>
    :root {
        --dark-bg: #0b0e14;
        --card-dark: #1a2332;
        --slate-900: #0f172a;
        --slate-800: #1e293b;
        --slate-400: #94a3b8;
        --blue-500: #3b82f6;
        --cyan-400: #22d3ee;
        --emerald-500: #10b981;
        --amber-500: #f59e0b;
        --indigo-500: #6366f1;
    }

    body {
        background-color: var(--dark-bg) !important;
        font-family: 'Tajawal', sans-serif;
        color: #f8fafc;
    }

    .guest-house-mgmt-page { min-height: 100vh; }

    /* Premium Hero Sleek */
    .premium-hero-sleek {
        position: relative;
        padding: 100px 0 120px;
        border-radius: 0;
        margin: -30px -30px 0 -30px;
        overflow: hidden;
        z-index: 10;
        box-shadow: 0 20px 50px rgba(0,0,0,0.4);
    }

    .hero-bg-visuals div { position: absolute; border-radius: 50%; filter: blur(100px); opacity: 0.3; pointer-events: none; }
    .glow-orb-1 { width: 400px; height: 400px; top: -100px; right: -50px; }
    .glow-orb-2 { width: 300px; height: 300px; bottom: -150px; left: -50px; }
    .noise-overlay { position: absolute; inset: 0; opacity: 0.03; background-image: url('data:image/svg+xml,...'); }

    .hero-content-wrapper { position: relative; z-index: 5; padding: 0 5%; }
    .badge-glass-premium { 
        background: rgba(255, 255, 255, 0.1); 
        backdrop-filter: blur(12px); 
        border: 1px solid rgba(255,255,255,0.1);
        padding: 8px 18px;
        border-radius: 100px;
        color: #e0e7ff;
        font-weight: 700;
        font-size: 0.85rem;
    }

    .fw-800 { font-weight: 800; }
    .max-w-600 { max-width: 600px; }

    .btn-action-glow-blue {
        background: var(--blue-500);
        color: white;
        border: none;
        font-weight: 800;
        box-shadow: 0 0 25px rgba(59, 130, 246, 0.4);
        transition: 0.4s;
    }
    .btn-action-glow-blue:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(59, 130, 246, 0.6);
        color: white;
    }

    /* Content Area */
    .content-shift-up { margin-top: -60px; position: relative; z-index: 20; padding: 0 5%; }

    /* Premium Card Dark */
    .premium-card-dark {
        background: var(--card-dark);
        border-radius: 35px;
        border: 1px solid rgba(255,255,255,0.05);
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        overflow: hidden;
    }

    .card-header-lux {
        padding: 25px 30px;
        border-bottom: 1px solid rgba(255,255,255,0.05);
        display: flex;
        align-items: center;
        gap: 15px;
        background: rgba(255,255,255,0.01);
    }
    .header-icon {
        width: 44px;
        height: 44px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.2rem;
    }
    .bg-blue-500 { background: var(--blue-500); }
    .bg-cyan-500 { background: #06b6d4; }
    .bg-emerald-500 { background: var(--emerald-500); }

    .form-group-lux { position: relative; }
    .label-lux { color: var(--slate-400); font-weight: 700; font-size: 0.85rem; margin-bottom: 12px; display: block; }
    
    .field-lux {
        width: 100%;
        background: #0f172a;
        border: 2px solid #2d3748;
        border-radius: 18px;
        padding: 16px 22px;
        color: white;
        font-weight: 600;
        transition: 0.3s;
    }
    .field-lux:focus {
        border-color: var(--blue-500);
        outline: none;
        background: #000;
        box-shadow: 0 0 0 5px rgba(59, 130, 246, 0.1);
    }
    .text-xl { font-size: 1.4rem; color: var(--cyan-400); }

    /* Large Upload Zone */
    .upload-zone-lux-large {
        height: 380px;
        border: 2px dashed #2d3748;
        border-radius: 30px;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        transition: 0.3s;
    }
    .upload-zone-lux-large:hover { border-color: #06b6d4; background: rgba(6, 182, 212, 0.03); }
    
    .preview-area-lux-large { height: 100%; display: flex; align-items: center; justify-content: center; }
    .upload-placeholder-lux { text-align: center; }
    
    .upload-hover-overlay {
        position: absolute;
        inset: 0;
        background: rgba(0,0,0,0.6);
        backdrop-filter: blur(4px);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: 0.3s;
    }
    .upload-zone-lux-large:hover .upload-hover-overlay { opacity: 1; }
    .btn-cyan-solid { background: #06b6d4; color: white; border: none; font-weight: 700; }

    .info-alert-lux {
        background: rgba(6, 182, 212, 0.08);
        color: #67e8f9;
        padding: 15px 20px;
        border-radius: 18px;
        font-size: 0.8rem;
    }

    /* Stats Inputs */
    .stat-input-box {
        background: #0f172a;
        border: 1px solid #1e293b;
        border-radius: 24px;
        padding: 20px;
        display: flex;
        gap: 15px;
        align-items: center;
        transition: 0.3s;
    }
    .stat-input-box:hover { transform: translateY(-3px); border-color: var(--slate-400); }
    
    .stat-icon-vibe {
        width: 50px;
        height: 50px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.3rem;
        flex-shrink: 0;
    }
    .stat-label-field {
        background: transparent;
        border: none;
        color: var(--slate-500);
        font-size: 0.75rem;
        font-weight: 800;
        width: 100%;
        margin-bottom: 2px;
    }
    .stat-value-field {
        background: transparent;
        border: none;
        color: white;
        font-size: 1.25rem;
        font-weight: 800;
        width: 100%;
        font-family: 'Outfit';
    }

    /* Gallery Card */
    .gallery-card-lux {
        height: 200px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
        border: 2px dashed #1e293b;
        cursor: pointer;
        transition: 0.4s;
    }
    .gallery-card-lux:hover { border-color: var(--emerald-500); transform: scale(1.03); }
    
    .gallery-preview-wrapper { height: 100%; }
    .gallery-placeholder { height: 100%; display: flex; flex-direction: column; align-items: center; justify-content: center; color: var(--slate-800); }
    
    .gallery-overlay {
        position: absolute;
        inset: 0;
        background: rgba(16, 185, 129, 0.6);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        opacity: 0;
        transition: 0.3s;
    }
    .gallery-card-lux:hover .gallery-overlay { opacity: 1; }

    .file-hidden {
        position: absolute;
        inset: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: pointer;
        z-index: 10;
    }

    .divider-lux { height: 1px; background: rgba(255,255,255,0.05); }

    /* Animations */
    .animate-reveal-right { animation: revealRight 1s both; }
    .animate-reveal-left { animation: revealLeft 1s both; }
    .animate-up { animation: fadeInUp 0.8s both; }

    @keyframes revealRight { from { opacity: 0; transform: translateX(50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes revealLeft { from { opacity: 0; transform: translateX(-50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes fadeInUp { from { opacity: 0; transform: translateY(35px); } to { opacity: 1; transform: translateY(0); } }

    .scroll-thin::-webkit-scrollbar { width: 6px; }
    .scroll-thin::-webkit-scrollbar-thumb { background: #334155; border-radius: 10px; }

    .bg-blue-500 { background: #3b82f6; }
    .bg-emerald-500 { background: #10b981; }
    .bg-amber-500 { background: #f59e0b; }
    .bg-indigo-500 { background: #6366f1; }

    @media (max-width: 991px) {
        .premium-hero-sleek { padding: 60px 0 80px; border-radius: 0 0 35px 35px; }
        .display-4 { font-size: 2.2rem; }
    }
    /* Premium Request Card (Copied & Adapted) */
    .request-card-premium {
        background: #1a2332;
        border-radius: 30px;
        padding: 30px;
        border: 1px solid rgba(255,255,255,0.05);
        transition: 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        height: 100%;
        display: flex;
        flex-direction: column;
        position: relative;
    }
    .request-card-premium:hover {
        transform: translateY(-8px) scale(1.02);
        border-color: var(--indigo-500);
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
    }

    .card-status-pill { position: absolute; top: 25px; left: 25px; }
    
    .card-top-vibe { display: flex; align-items: center; gap: 15px; }
    .user-avatar-premium {
        width: 60px; height: 60px;
        border-radius: 20px;
        display: flex; align-items: center; justify-content: center;
        position: relative;
        color: white; font-size: 1.4rem;
    }
    .avatar-ring { position: absolute; inset: -3px; border: 2px solid rgba(255,255,255,0.2); border-radius: 24px; opacity: 0.5; }

    .detail-grid-compact { display: grid; grid-template-columns: 1fr 1fr; gap: 12px; }
    .detail-item-compact {
        background: rgba(255,255,255,0.03);
        padding: 10px 14px; border-radius: 12px;
    }
    .detail-item-compact label { display: block; font-size: 0.65rem; color: var(--slate-400); font-weight: 700; margin-bottom: 4px; }
    .detail-item-compact span { display: block; font-size: 0.85rem; color: white; font-weight: 600; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }

    
</style>
@endsection
