@extends('layouts.app')

@section('content')
<div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);">
    <div class="hero-content">
        <div class="hero-greeting text-white-50">إدارة تطبيق الموبايل API Unit 📱</div>
        <h1 class="hero-title">المشاريع والحملات (الموبايل)</h1>
        <p class="hero-subtitle">تخصيص المحتوى والصور التي تظهر لمستخدمي التطبيق وتفعيل/تعطيل العرض</p>
    </div>
</div>

<div class="container-fluid py-4">
    <div class="row g-4">
        {{-- Projects Section --}}
        <div class="col-lg-12">
            <div class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up">
                 <div class="p-4 border-bottom bg-white bg-opacity-5 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold"><i class="bi bi-grid-3x3-gap me-2 text-info"></i> مشاريع التطبيق</h5>
                </div>
                <div class="p-4">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="bg-light">
                                <tr>
                                    <th>المشروع</th>
                                    <th>الحالة على التطبيق</th>
                                    <th>محتوى مخصص</th>
                                    <th class="text-center">الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($projects as $project)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="rounded border bg-light overflow-hidden" style="width: 50px; height: 50px;">
                                                @if($project->image_path)
                                                    <img src="{{ asset('storage/' . $project->image_path) }}" class="w-100 h-100 object-fit-cover">
                                                @else
                                                    <div class="w-100 h-100 d-flex align-items-center justify-content-center text-muted"><i class="bi bi-image"></i></div>
                                                @endif
                                            </div>
                                            <span class="fw-bold">{{ $project->name }}</span>
                                        </div>
                                    </td>
                                    <td>
                                         @if($project->show_on_mobile)
                                            <span class="badge bg-success-subtle text-success border border-success-subtle">نشط <i class="bi bi-check-circle ms-1"></i></span>
                                        @else
                                            <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">مخفي <i class="bi bi-eye-slash ms-1"></i></span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($project->mobile_content)
                                            <span class="text-success"><i class="bi bi-file-earmark-text"></i> يوجد</span>
                                        @else
                                            <span class="text-muted small">افتراضي (نفس الويب)</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-outline-primary rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#editProjectMobile{{ $project->id }}">
                                            تخصيص للموبايل <i class="bi bi-phone ms-1"></i>
                                        </button>
                                    </td>
                                </tr>

                                {{-- Edit Modal --}}
                                <div class="modal fade" id="editProjectMobile{{ $project->id }}" tabindex="-1">
                                    <div class="modal-dialog modal-lg">
                                        <form action="{{ route('mobile.projects.update.mobile', $project) }}" method="POST" class="modal-content glass-card border-0">
                                            @csrf @method('PUT')
                                            <div class="modal-header border-0">
                                                <h5 class="modal-title fw-bold">إعدادات الموبايل: {{ $project->name }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body p-4">
                                                <div class="form-check form-switch mb-4 p-3 bg-light rounded-3 border">
                                                    <input class="form-check-input ms-0 me-2 float-end" type="checkbox" name="show_on_mobile" id="showProj{{ $project->id }}" {{ $project->show_on_mobile ? 'checked' : '' }} value="1">
                                                    <label class="form-check-label fw-bold" for="showProj{{ $project->id }}">عرض هذا المشروع في تطبيق الموبايل</label>
                                                    <div class="small text-muted mt-1 me-4">عند التعطيل لن يظهر المشروع لمستخدمي التطبيق نهائياً.</div>
                                                </div>

                                                <label class="form-label fw-bold text-primary">وصف مخصص للتطبيق (اختياري)</label>
                                                <textarea name="mobile_content" class="form-control" rows="6" placeholder="اكتب وصفاً مختصراً وجذاباً يناسب شاشات الموبايل... (اتركه فارغاً لاستخدام الوصف العام)">{{ $project->mobile_content }}</textarea>
                                                <div class="form-text text-muted"><i class="bi bi-info-circle"></i> يفضل أن يكون النص قصيراً ومباشراً لمستخدمي الهواتف.</div>
                                            </div>
                                            <div class="modal-footer border-0">
                                                <button type="submit" class="btn btn-primary rounded-pill px-4 shadow-sm w-100">حفظ الإعدادات</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        {{-- Campaigns Section --}}
        <div class="col-lg-12">
            <div class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up animate-delay-1">
                 <div class="p-4 border-bottom bg-white bg-opacity-5 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold"><i class="bi bi-megaphone me-2 text-warning"></i> حملات التبرع (App)</h5>
                </div>
                <div class="p-4">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="bg-light">
                                <tr>
                                    <th>الحملة</th>
                                    <th>مقياس التقدم</th>
                                    <th>الحالة</th>
                                    <th class="text-center">الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($campaigns as $campaign)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                             <div class="rounded border bg-light overflow-hidden" style="width: 50px; height: 50px;">
                                                @if($campaign->image_path)
                                                    <img src="{{ asset('storage/' . $campaign->image_path) }}" class="w-100 h-100 object-fit-cover">
                                                @else
                                                    <div class="w-100 h-100 d-flex align-items-center justify-content-center text-muted"><i class="bi bi-image"></i></div>
                                                @endif
                                            </div>
                                            <div>
                                                <div class="fw-bold">{{ $campaign->name }}</div>
                                                <span class="x-small text-muted">{{ $campaign->remaining_days ?? 0 }} يوم متبقي</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td style="width: 30%">
                                        <div class="d-flex justify-content-between x-small mb-1">
                                            <span>{{ number_format($campaign->current_amount) }}</span>
                                            <span class="text-muted">من {{ number_format($campaign->goal_amount) }}</span>
                                        </div>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-warning" style="width: {{ $campaign->goal_amount > 0 ? min(100, ($campaign->current_amount / $campaign->goal_amount) * 100) : 0 }}%"></div>
                                        </div>
                                    </td>
                                    <td>
                                         @if($campaign->show_on_mobile)
                                            <span class="badge bg-success-subtle text-success border border-success-subtle">نشط</span>
                                        @else
                                            <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">مخفي</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-outline-warning rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#editCampMobile{{ $campaign->id }}">
                                            تخصيص <i class="bi bi-phone ms-1"></i>
                                        </button>
                                    </td>
                                </tr>

                                 {{-- Edit Modal --}}
                                <div class="modal fade" id="editCampMobile{{ $campaign->id }}" tabindex="-1">
                                    <div class="modal-dialog modal-lg">
                                        <form action="{{ route('mobile.campaigns.update.mobile', $campaign) }}" method="POST" class="modal-content glass-card border-0">
                                            @csrf @method('PUT')
                                            <div class="modal-header border-0">
                                                <h5 class="modal-title fw-bold">إعدادات الموبايل: {{ $campaign->name }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body p-4">
                                                <div class="form-check form-switch mb-4 p-3 bg-light rounded-3 border">
                                                    <input class="form-check-input ms-0 me-2 float-end" type="checkbox" name="show_on_mobile" id="showCamp{{ $campaign->id }}" {{ $campaign->show_on_mobile ? 'checked' : '' }} value="1">
                                                    <label class="form-check-label fw-bold" for="showCamp{{ $campaign->id }}">ظهور الحملة في التطبيق</label>
                                                </div>

                                                <label class="form-label fw-bold text-warning">نص ترويجي للتطبيق (Pitch)</label>
                                                <textarea name="mobile_content" class="form-control" rows="6" placeholder="اكتب رسالة قصيرة ومؤثرة تظهر تحت الحملة في التطبيق...">{{ $campaign->mobile_content }}</textarea>
                                            </div>
                                            <div class="modal-footer border-0">
                                                <button type="submit" class="btn btn-warning text-dark fw-bold rounded-pill px-4 shadow-sm w-100">حفظ الإعدادات</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .glass-card { background: rgba(255,255,255,0.85); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.3); border-radius: 20px; box-shadow: 0 8px 32px rgba(0,0,0,0.05); }
    .x-small { font-size: 0.7rem; }
    .animate-delay-1 { animation-delay: 0.1s; }
</style>
@endsection
