<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebEvent extends Model
{
    protected $table = 'web_events';

    protected $fillable = [
        'title',
        'content',
        'image_path',
        'location',
        'category',
        'event_date',
        'event_end_date',
        'views_count',
        'shares_count',
        'is_featured',
        'published_at',
    ];

    protected $casts = [
        'event_date' => 'datetime',
        'event_end_date' => 'datetime',
        'published_at' => 'datetime',
        'is_featured' => 'boolean',
    ];
}
