<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Campaign extends Model
{
    protected $fillable = [
        'name',
        'season_title',
        'season_year',
        'start_date',
        'end_date',
        'status',
        'project_id',
        'manager_user_id',
        'deputy_user_id',
        'manager_photo_url',
        'deputy_photo_url',
        'image_path',
        'category',
        'website_content',
        'goal_amount',
        'goal_unit',
        'current_amount',
        'beneficiaries_count',
        'share_price',
        'ui_contribute_btn',
        'ui_remind_btn',
        'ui_ended_btn',
        'ui_filter_upcoming',
        'ui_collected_label',
        'ui_benefited_label',
        'ui_share_label',
        'ui_goal_label',
        'icon_path',
        'start_date_text',
        'ui_progress_override',
        'ui_collected_override',
        'ui_goal_override',
        'ui_beneficiaries_override',
        'ui_share_override',
        'ui_theme_color',
        'ui_button_color',
        'action_url'
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date'
    ];

    public function donations(): HasMany
    {
        return $this->hasMany(Donation::class);
    }
    public function beneficiaries(): HasMany
    {
        return $this->hasMany(Beneficiary::class);
    }
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function manager(): BelongsTo
    {
        return $this->belongsTo(User::class , 'manager_user_id');
    }

    public function deputy(): BelongsTo
    {
        return $this->belongsTo(User::class , 'deputy_user_id');
    }


    public function volunteers(): BelongsToMany
    {
        return $this->belongsToMany(User::class , 'campaign_volunteers')
            ->withPivot('role', 'started_at', 'hours')
            ->withTimestamps();
    }

    public function monthlyVolunteers(): HasMany
    {
        return $this->hasMany(CampaignMonthlyVolunteer::class)->orderByDesc('year')->orderByDesc('month');
    }

    public function dailyMenus(): HasMany
    {
        return $this->hasMany(CampaignDailyMenu::class)->orderBy('day_date');
    }
}
