# API Documentation - Ensan System Final v1.0
*(Last Updated: 2026-02-22)*

This document provides the definitive technical specification for connecting your website to the Ensan System.

## 1. Connection Details

-   **Development Base URL:** `http://192.168.1.142/public/api/v1`
-   **Production Base URL:** (As provided by server administrator)
-   **Output Format:** `application/json`
-   **Auth Type:** 
    -   *Public Endpoints:* No authentication required.
    -   *Admin Endpoints:* Requires Bearer Token.


## 2. Public Website Endpoints

### 2.1 Landing Page
-   **Endpoint:** `GET /website/landing`
-   **Description:** Returns all data needed for the home page.
-   **Key Sections returned:** `hero`, `stats`, `gallery`, `projects`, `campaigns`, `testimonials`, `partners`, `branches`, `news`.

### 2.2 Volunteer Page
-   **Endpoint:** `GET /website/volunteer`
-   **Returns:**
    -   `hero`: Title, Subtitle, Image.
    -   `slider`: Array of up to 10 images.
    -   `stats`: Volunteer counts, hours, etc.
    -   `wall`: List of top volunteers.

### 2.3 Guest House Page
-   **Endpoint:** `GET /website/guest-house`
-   **Returns:**
    -   `hero`: Header data.
    -   `stats`: Beds count, patients served, etc.
    -   `slider`: Array of up to 10 images.

### 2.4 Contact Page
-   **Endpoint:** `GET /website/contact`
-   **Returns:**
    -   `channels`: Phone, Email, WhatsApp, Office Address.
    -   `social_links`: FB, Twitter, Instagram.
    -   `working_hours`: Operating times.


## 3. Form Submissions (POST Endpoints)

### 3.1 Room Booking (Guest House)
-   **Endpoint:** `POST /website/room-booking`
-   **Content-Type:** `multipart/form-data`
-   **Fields:**
    | Key | Type | Required | Description |
    | :--- | :--- | :--- | :--- |
    | `name` | String | Yes | Applicant Name |
    | `phone` | String | Yes | Contact Phone |
    | `national_id` | String | No | National ID Number |
    | `arrival_date` | Date | No | YYYY-MM-DD |
    | `expected_duration`| String | No | e.g., "5 days" |
    | `medical_center` | String | No | Hospital Name |
    | `patient_id` | File | No | Patient ID Image |
    | `medical_transfer` | File | No | Medical Document Image |
    | `followup_card` | File | No | Follow-up card Image |

### 3.2 Volunteer Request
-   **Endpoint:** `POST /website/volunteer`
-   **Content-Type:** `multipart/form-data`
-   **Fields:** `name`, `phone`, `email`, `cv` (File), `area_of_interest`, `address`, `national_id`, `birth_date`.

---

## 4. Admin/Management (For Admin Panel)

### 4.1 Update Global Settings
-   **Endpoint:** `POST /admin/website/settings`
-   **Usage:** Send any keys from the `.env` or specific setting keys (e.g., `stats_donations`, `hero_title_primary`).
-   **Image Uploads:** Supports `gallery_image_1..10`, `news_slider_1..10`, `contact_slider_1..10`.
-   **Deletion:** Send the key with a `null` value to delete an image or reset a setting.

---

## 5. Deployment Checklist
1.  **IP Connectivity:** Ensure your device is on the same network `192.168.1.x`.
2.  **Storage Link:** Run `php artisan storage:link` if images don't appear (Already handled on this system).
3.  **PHP Extensions:** Ensure `mbstring` and `gd` are enabled in PHP 8.2+ settings.
